/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.client.gui.text;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import redstone.multimeter.client.gui.text.BaseText;
import redstone.multimeter.client.gui.text.Text;
import redstone.multimeter.client.gui.text.Texts;

public class TranslatableText
extends BaseText {
    private static final Pattern ARG_FORMAT = Pattern.compile("%(?:(\\d+)\\$)?([A-Za-z%]|$)");
    private final String key;
    private final Object[] args;
    private List<Text> resolved;
    private class_2477 resolvedLanguage;

    TranslatableText(String key, Object ... args) {
        this.key = key;
        this.args = args;
    }

    @Override
    void buildString(StringBuilder sb, boolean formatted) {
        class_2477 language = class_2477.method_10517();
        if (this.resolved == null || this.resolvedLanguage != language) {
            String translation = language.method_48307(this.key);
            this.resolvedLanguage = language;
            this.resolve(translation);
        }
        this.buildString(sb, formatted, this.resolved);
    }

    @Override
    class_5250 buildComponent() {
        Object[] args = new Object[this.args.length];
        for (int i = 0; i < args.length; ++i) {
            Object arg = this.args[i];
            if (arg instanceof Text) {
                arg = ((Text)arg).resolve();
            }
            args[i] = arg;
        }
        return class_2561.method_43469((String)this.key, (Object[])args);
    }

    private void resolve(String translation) {
        this.resolved = new ArrayList<Text>();
        Matcher matcher = ARG_FORMAT.matcher(translation);
        int nextArgIndex = 0;
        int nextCharIndex = 0;
        while (matcher.find(nextCharIndex)) {
            int matchStart = matcher.start();
            int matchEnd = matcher.end();
            if (matchStart > nextCharIndex) {
                this.resolved.add(Texts.literal(translation.substring(nextCharIndex, matchStart)));
            }
            String formatting = matcher.group(2);
            String partWithFormatting = translation.substring(matchStart, matchEnd);
            if ("%".equals(formatting) && "%%".equals(partWithFormatting)) {
                this.resolved.add(Texts.literal("%"));
            } else {
                int argIndex;
                if (!"s".equals(formatting)) {
                    throw new IllegalStateException("Unsupported format: '" + partWithFormatting + "'");
                }
                String matchedArgIndex = matcher.group(1);
                int n = argIndex = matchedArgIndex != null ? Integer.parseInt(matchedArgIndex) - 1 : nextArgIndex++;
                if (argIndex < this.args.length) {
                    this.resolved.add(this.resolveArg(argIndex));
                }
            }
            nextCharIndex = matchEnd;
        }
        if (nextCharIndex < translation.length()) {
            this.resolved.add(Texts.literal(translation.substring(nextCharIndex)));
        }
    }

    private Text resolveArg(int index) {
        if (index >= this.args.length) {
            throw new IndexOutOfBoundsException(index);
        }
        Object arg = this.args[index];
        if (arg == null) {
            return Texts.literal("null");
        }
        return Texts.of(arg);
    }
}

