/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.client.gui.tooltip;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_304;
import redstone.multimeter.client.MultimeterClient;
import redstone.multimeter.client.gui.text.Text;
import redstone.multimeter.client.gui.text.Texts;
import redstone.multimeter.client.gui.tooltip.Tooltip;
import redstone.multimeter.client.gui.tooltip.TooltipBuilder;

public class Tooltips {
    public static final Tooltip EMPTY = Tooltip.EMPTY;

    public static Tooltip empty() {
        return EMPTY;
    }

    public static Tooltip lines(Collection<Text> lines) {
        return lines.isEmpty() ? Tooltip.EMPTY : new Tooltip(new ArrayList<Text>(lines));
    }

    public static Tooltip lines(List<String> lines) {
        return Tooltips.lines(lines.stream().map(Texts::literal).collect(Collectors.toList()));
    }

    public static Tooltip lines(Object ... lines) {
        return Tooltips.lines(Stream.of(lines).map(Texts::of).collect(Collectors.toList()));
    }

    public static Tooltip split(Text text) {
        return Tooltips.split(text, 200);
    }

    public static Tooltip split(Text text, int width) {
        return Tooltips.lines(MultimeterClient.INSTANCE.getFontRenderer().split(text, width));
    }

    public static Tooltip literal(String text) {
        return Tooltips.literal(text, 200);
    }

    public static Tooltip literal(String text, int width) {
        return Tooltips.split(Texts.literal(text), width);
    }

    public static Tooltip translatable(String text) {
        return Tooltips.translatable(text, 200);
    }

    public static Tooltip translatable(String text, int width) {
        return Tooltips.split(Texts.translatable(text), width);
    }

    public static Tooltip keybind(class_304 keybind) {
        return Tooltips.keybind(Texts.translatable(keybind.method_1431()), keybind);
    }

    public static Tooltip keybind(class_304 keybind, Object ... keys) {
        return Tooltips.keybind(Texts.translatable(keybind.method_1431()), keys);
    }

    public static Tooltip keybind(Text keybind, Object ... keys) {
        return Tooltips.lines(keybind, Texts.keyValue(Texts.translatable("rsmm.keybind"), Texts.keybinds(keys)));
    }

    public static TooltipBuilder builder() {
        return new TooltipBuilder();
    }
}

