/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.client.meter;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.List;
import net.minecraft.class_2487;
import redstone.multimeter.client.MultimeterClient;
import redstone.multimeter.client.SavedMeterGroup;
import redstone.multimeter.client.SavedMeterGroupsManager;
import redstone.multimeter.client.meter.log.ClientLogManager;
import redstone.multimeter.common.meter.Meter;
import redstone.multimeter.common.meter.MeterGroup;
import redstone.multimeter.common.meter.MeterProperties;

public class ClientMeterGroup
extends MeterGroup {
    private final MultimeterClient client;
    private final ClientLogManager logManager;
    private boolean subscribed;
    private boolean previewing;
    private int slot = -1;
    private String name;
    private int nextIndex;

    public ClientMeterGroup(MultimeterClient client) {
        super("If you see this something has gone wrong...");
        this.client = client;
        this.logManager = new ClientLogManager(this);
        this.name = super.getName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void clear() {
        super.clear();
        this.nextIndex = 0;
        this.client.getHud().updateMeterList();
        this.client.getTutorial().onMeterGroupRefreshed();
    }

    @Override
    protected void meterAdded(Meter meter) {
        ++this.nextIndex;
        this.client.getHud().updateMeterList();
        this.client.getTutorial().onMeterAdded(meter);
    }

    @Override
    protected void meterRemoved(Meter meter) {
        if (!this.hasMeters()) {
            this.nextIndex = 0;
        }
        this.client.getHud().updateMeterList();
        this.client.getTutorial().onMeterRemoved(meter);
    }

    @Override
    protected void meterUpdated(Meter meter) {
        this.client.getHud().updateMeterList();
    }

    @Override
    protected void indexChanged(Meter meter) {
        this.client.getHud().updateMeterList();
    }

    @Override
    public ClientLogManager getLogManager() {
        return this.logManager;
    }

    public MultimeterClient getMultimeterClient() {
        return this.client;
    }

    public boolean isSubscribed() {
        return this.subscribed;
    }

    public boolean isPreviewing() {
        return this.previewing;
    }

    public int getSlot() {
        return this.slot;
    }

    public int getNextMeterIndex() {
        return this.nextIndex;
    }

    public boolean hasMeter(Meter meter) {
        return this.hasMeter(meter.getId());
    }

    public void updateMeters(List<Long> removedMeters, Long2ObjectMap<MeterProperties> meterUpdates, List<Long> meters) {
        Meter meter;
        for (int index = 0; index < removedMeters.size(); ++index) {
            long id = removedMeters.get(index);
            meter = this.getMeter(id);
            if (meter == null) continue;
            this.removeMeter(meter);
        }
        for (Long2ObjectMap.Entry entry : meterUpdates.long2ObjectEntrySet()) {
            long id = entry.getLongKey();
            MeterProperties newProperties = (MeterProperties)entry.getValue();
            Meter meter2 = this.getMeter(id);
            if (meter2 == null) {
                this.addMeter(new Meter(id, newProperties.mutable()));
                continue;
            }
            this.updateMeter(meter2, newProperties);
        }
        for (int index = 0; index < meters.size(); ++index) {
            long id = meters.get(index);
            meter = this.getMeter(id);
            if (meter == null) continue;
            this.setIndex(meter, index);
        }
    }

    public void toggleHidden(Meter meter) {
        meter.toggleHidden();
        this.meterUpdated(meter);
    }

    public void subscribe(int newSlot, String newName) {
        this.subscribed = true;
        this.previewing = false;
        this.slot = newSlot;
        this.name = newName;
        this.logManager.getPrinter().onNewMeterGroup();
        this.clear();
        this.client.refreshMeterGroup();
        this.client.getTutorial().onJoinMeterGroup();
    }

    public void unsubscribe(boolean disconnect) {
        this.subscribed = false;
        this.previewing = false;
        this.slot = -1;
        this.name = super.getName();
        this.logManager.getPrinter().stop(!disconnect);
        this.clear();
        this.client.getTutorial().onLeaveMeterGroup();
    }

    public void refresh(class_2487 nbt) {
        this.updateFromNbt(nbt);
        this.client.getHud().updateMeterList();
        this.client.getTutorial().onMeterGroupRefreshed();
    }

    public void preview(int newSlot, String newName, List<MeterProperties> meters) {
        this.subscribed = false;
        this.previewing = true;
        this.slot = newSlot;
        this.name = newName;
        this.clear();
        for (MeterProperties meter : meters) {
            this.addMeter(new Meter(meter.mutable()));
        }
        this.client.getHud().updateMeterList();
    }

    public void stopPreviewing() {
        this.subscribed = false;
        this.previewing = false;
        this.slot = -1;
        this.name = super.getName();
        this.clear();
        this.client.getHud().updateMeterList();
    }

    public void tick() {
        this.logManager.tick();
    }

    public boolean isDirty() {
        if (this.slot < 0) {
            return false;
        }
        List<Meter> meters = this.getMeters();
        SavedMeterGroupsManager savedMeterGroups = this.client.getSavedMeterGroupsManager();
        SavedMeterGroup savedMeterGroup = savedMeterGroups.getSavedMeterGroup(this.slot);
        List<MeterProperties> savedMeters = savedMeterGroup.getMeters();
        if (meters.size() != savedMeters.size()) {
            return true;
        }
        for (int i = 0; i < meters.size(); ++i) {
            MeterProperties savedProperties;
            MeterProperties properties = meters.get(i).getProperties();
            if (properties.equals(savedProperties = savedMeters.get(i))) continue;
            return true;
        }
        return false;
    }
}

