/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.client.meter;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_7923;
import redstone.multimeter.RedstoneMultimeterMod;
import redstone.multimeter.client.InputHandler;
import redstone.multimeter.client.Keybinds;
import redstone.multimeter.client.MultimeterClient;
import redstone.multimeter.client.option.Options;
import redstone.multimeter.common.DimPos;
import redstone.multimeter.common.meter.ColorPicker;
import redstone.multimeter.common.meter.MeterProperties;
import redstone.multimeter.common.meter.MeterPropertiesManager;
import redstone.multimeter.common.meter.event.EventType;

public class ClientMeterPropertiesManager
extends MeterPropertiesManager {
    private static final String PROPERTIES_PATH = "meter/default_properties";
    private static final String RESOURCES_PATH = String.format("/assets/%s/%s", "redstone_multimeter", "meter/default_properties");
    private static final String FILE_EXTENSION = ".json";
    private static final String DEFAULT_KEY = "block";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final MultimeterClient client;
    private final Path dir;
    private final Map<class_2960, MeterProperties> defaults;
    private final Map<class_2960, MeterProperties> overrides;
    private final Map<class_2960, MeterProperties> cache;

    public ClientMeterPropertiesManager(MultimeterClient client) {
        this.client = client;
        this.dir = this.client.getConfigDirectory().resolve(PROPERTIES_PATH);
        this.defaults = new HashMap<class_2960, MeterProperties>();
        this.overrides = new HashMap<class_2960, MeterProperties>();
        this.cache = new HashMap<class_2960, MeterProperties>();
        this.initDefaults();
        if (!Files.exists(this.dir, new LinkOption[0])) {
            try {
                Files.createDirectories(this.dir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("unable to create parent directories of meter properties file", e);
            }
        }
    }

    @Override
    protected class_1937 getLevel(DimPos pos) {
        class_310 minecraft = this.client.getMinecraft();
        return pos.is((class_1937)minecraft.field_1687) ? minecraft.field_1687 : null;
    }

    @Override
    protected void postValidation(MeterProperties.MutableMeterProperties properties, class_1937 level, class_2338 pos) {
        class_2680 state = level.method_8320(pos);
        class_2248 block = state.method_26204();
        MeterProperties defaultProperties = this.getDefaultProperties(block);
        if (defaultProperties != null) {
            properties.fill(defaultProperties);
        }
        if (properties.getName() != null && ((Boolean)Options.RedstoneMultimeter.NUMBERED_NAMES.get()).booleanValue()) {
            String name = properties.getName();
            int number = this.client.getMeterGroup().getNextMeterIndex();
            properties.setName(String.format("%s %d", name, number));
        }
        if (properties.getColor() == null) {
            properties.setColor(((ColorPicker)Options.RedstoneMultimeter.COLOR_PICKER.get()).next());
        }
        if (((Boolean)Options.RedstoneMultimeter.SHIFTY_METERS.get()).booleanValue()) {
            properties.setMovable(!InputHandler.isShiftDown());
        }
        for (int index = 0; index < EventType.ALL.length; ++index) {
            class_304 keybind = Keybinds.TOGGLE_EVENT_TYPES[index];
            if (!keybind.method_1434()) continue;
            EventType type = EventType.ALL[index];
            properties.toggleEventType(type);
        }
        if (((Boolean)Options.RedstoneMultimeter.AUTO_RANDOM_TICKS.get()).booleanValue() && state.method_26229() && !properties.hasEventType(EventType.RANDOM_TICK)) {
            properties.toggleEventType(EventType.RANDOM_TICK);
        }
    }

    public Map<class_2960, MeterProperties> getDefaults() {
        return Collections.unmodifiableMap(this.defaults);
    }

    public Map<class_2960, MeterProperties> getOverrides() {
        return Collections.unmodifiableMap(this.overrides);
    }

    public <T extends MeterProperties> void update(Map<class_2960, T> newOverrides) {
        HashMap<class_2960, MeterProperties> prev = new HashMap<class_2960, MeterProperties>(this.overrides);
        this.overrides.clear();
        this.cache.clear();
        for (Map.Entry<class_2960, T> entry : newOverrides.entrySet()) {
            class_2960 key = entry.getKey();
            MeterProperties properties = (MeterProperties)entry.getValue();
            prev.remove(key);
            this.overrides.put(key, properties.immutable());
        }
        this.save();
        for (class_2960 key : prev.keySet()) {
            this.deleteOverrideFile(key);
        }
    }

    public MeterProperties getDefaultProperties(class_2248 block) {
        class_2960 key = class_7923.field_41175.method_10221((Object)block);
        if (key == null) {
            return null;
        }
        return this.cache.computeIfAbsent(key, _key -> {
            String namespace = key.method_12836();
            class_2960 defaultKey = class_2960.method_60655((String)namespace, (String)DEFAULT_KEY);
            return new MeterProperties.MutableMeterProperties().fill(this.overrides.get(key)).fill(this.defaults.get(key)).fill(this.overrides.get(defaultKey)).fill(this.defaults.get(defaultKey)).immutable();
        });
    }

    private void initDefaults() {
        HashSet<String> namespaces = new HashSet<String>();
        for (class_2960 key : class_7923.field_41175.method_10235()) {
            this.loadDefaultProperties(key);
            if (!namespaces.add(key.method_12836())) continue;
            this.loadDefaultProperties(class_2960.method_60655((String)key.method_12836(), (String)DEFAULT_KEY));
        }
    }

    private void loadDefaultProperties(class_2960 key) {
        String path = String.format("%s/%s/%s%s", RESOURCES_PATH, key.method_12836(), key.method_12832(), FILE_EXTENSION);
        InputStream resource = this.getClass().getResourceAsStream(path);
        if (resource == null) {
            return;
        }
        try (InputStreamReader isr = new InputStreamReader(resource);){
            ClientMeterPropertiesManager.loadProperties(this.defaults, key, isr);
        }
        catch (JsonIOException | JsonSyntaxException | IOException e) {
            RedstoneMultimeterMod.LOGGER.warn("exception while loading default meter properties", e);
        }
    }

    public void reload() {
        this.overrides.clear();
        this.cache.clear();
        try {
            for (Path dirForNamespace : Files.newDirectoryStream(this.dir, f -> Files.isDirectory(f, new LinkOption[0]))) {
                String namespace = dirForNamespace.getFileName().toString();
                for (Path file : Files.newDirectoryStream(dirForNamespace, f -> Files.isRegularFile(f, new LinkOption[0]))) {
                    this.loadUserOverrides(namespace, file);
                }
            }
        }
        catch (Exception e) {
            RedstoneMultimeterMod.LOGGER.warn("exception while reloading meter properties", (Throwable)e);
        }
    }

    private void loadUserOverrides(String namespace, Path file) throws Exception {
        String path = file.getFileName().toString();
        if (!path.endsWith(FILE_EXTENSION)) {
            return;
        }
        path = path.substring(0, path.length() - FILE_EXTENSION.length());
        try (BufferedReader br = Files.newBufferedReader(file);){
            ClientMeterPropertiesManager.loadProperties(this.overrides, class_2960.method_60655((String)namespace, (String)path), br);
        }
    }

    private static void loadProperties(Map<class_2960, MeterProperties> map, class_2960 key, Reader reader) {
        JsonElement rawJson = (JsonElement)GSON.fromJson(reader, JsonElement.class);
        if (rawJson.isJsonObject()) {
            JsonObject json = rawJson.getAsJsonObject();
            MeterProperties properties = MeterProperties.fromJson(json);
            map.put(key, properties);
        }
    }

    public void save() {
        try {
            for (Map.Entry<class_2960, MeterProperties> entry : this.overrides.entrySet()) {
                class_2960 key = entry.getKey();
                MeterProperties properties = entry.getValue();
                this.saveUserOverrides(key, properties);
            }
        }
        catch (Exception e) {
            RedstoneMultimeterMod.LOGGER.warn("exception while saving meter properties", (Throwable)e);
        }
    }

    private void saveUserOverrides(class_2960 key, MeterProperties properties) throws Exception {
        String namespace = key.method_12836();
        String path = key.method_12832();
        Path dirForNamespace = this.dir.resolve(namespace);
        if (!Files.exists(dirForNamespace, new LinkOption[0])) {
            Files.createDirectories(dirForNamespace, new FileAttribute[0]);
        }
        if (!Files.isDirectory(dirForNamespace, new LinkOption[0])) {
            throw new IOException("Unable to save properties for '" + key.toString() + "' - the '" + namespace + "' folder does not exist and cannot be created!");
        }
        Path file = dirForNamespace.resolve(String.format("%s%s", path, FILE_EXTENSION));
        if (Files.exists(file, new LinkOption[0]) && !Files.isRegularFile(file, new LinkOption[0])) {
            RedstoneMultimeterMod.LOGGER.warn("Unable to save properties for '" + key.toString() + "' - the '" + path + "' file does not exist and cannot be created!");
            return;
        }
        JsonObject json = properties.toJson();
        try (BufferedWriter bw = Files.newBufferedWriter(file, new OpenOption[0]);){
            bw.write(GSON.toJson((JsonElement)json));
        }
    }

    private void deleteOverrideFile(class_2960 key) {
        String namespace = key.method_12836();
        String path = key.method_12832();
        try {
            Path folder = this.dir.resolve(namespace);
            Path file = folder.resolve(String.format("%s%s", path, FILE_EXTENSION));
            Files.deleteIfExists(file);
        }
        catch (IOException e) {
            RedstoneMultimeterMod.LOGGER.warn("exception while deleting meter properties override file", (Throwable)e);
        }
    }
}

