/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.client.option;

import redstone.multimeter.client.InputHandler;
import redstone.multimeter.client.gui.element.button.BasicButton;
import redstone.multimeter.client.gui.element.button.Button;
import redstone.multimeter.client.gui.text.Text;
import redstone.multimeter.client.gui.text.Texts;
import redstone.multimeter.client.gui.tooltip.Tooltip;
import redstone.multimeter.client.gui.tooltip.Tooltips;
import redstone.multimeter.client.option.BaseOption;
import redstone.multimeter.client.option.Cyclable;

public class EnumOption<T extends Enum<T>>
extends BaseOption<T> {
    protected final Class<T> type;

    public EnumOption(String key, String legacyKey, Class<T> type, T defaultValue) {
        super(key, legacyKey, defaultValue);
        this.type = type;
    }

    @Override
    public Text getDisplayValue() {
        return Texts.translatable(this.translationKey() + ".value." + this.getAsString() + ".name");
    }

    private Tooltip getTooltip() {
        return Tooltips.translatable(this.translationKey() + ".value." + this.getAsString() + ".description");
    }

    @Override
    public String getAsString() {
        return ((Cyclable)((Object)((Enum)this.get()))).key();
    }

    @Override
    public void setFromString(String value) {
        T v = Cyclable.byKey(this.type, value);
        if (v == null) {
            v = Cyclable.byLegacyKey(this.type, value);
        }
        if (v == null) {
            throw new IllegalStateException("could not find value " + value + " of type " + this.type.getSimpleName() + " for option " + this.key());
        }
        this.set(v);
    }

    @Override
    public Button createControl(int width, int height) {
        return new BasicButton(0, 0, width, height, this::getDisplayValue, this::getTooltip, (button, event) -> {
            this.cycle(!InputHandler.isShiftDown());
            return true;
        });
    }

    public void cycle(boolean forward) {
        this.set(forward ? Cyclable.next(this.type, (Enum)this.get()) : Cyclable.prev(this.type, (Enum)this.get()));
    }
}

