/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.client.render;

import java.util.function.Predicate;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_765;
import net.minecraft.class_9974;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import redstone.multimeter.client.MultimeterClient;
import redstone.multimeter.client.meter.ClientMeterGroup;
import redstone.multimeter.client.option.Options;
import redstone.multimeter.client.render.MeterHighlightMode;
import redstone.multimeter.client.render.MeterNameTagMode;
import redstone.multimeter.common.meter.Meter;
import redstone.multimeter.util.ColorUtils;

public class MeterRenderer {
    private static final class_265 OUTLINE_SHAPE = class_259.method_1081((double)-0.002f, (double)-0.002f, (double)-0.002f, (double)1.002f, (double)1.002f, (double)1.002f);
    private final MultimeterClient client;
    private final class_310 minecraft;

    public MeterRenderer(MultimeterClient client) {
        this.client = client;
        this.minecraft = this.client.getMinecraft();
    }

    public void renderMeterHighlights(class_4587 poses, class_4597.class_4598 bufferSource) {
        this.renderMeters(poses, bufferSource, this::shouldRenderHighlight, this::renderHighlight);
    }

    public void renderMeterNameTags(class_4587 poses, class_4597.class_4598 bufferSource) {
        this.renderMeters(poses, bufferSource, this::shouldRenderNameTag, this::renderNameTag);
    }

    private void renderMeters(class_4587 poses, class_4597.class_4598 bufferSource, Predicate<Meter> predicate, MeterPartRenderer renderer) {
        ClientMeterGroup meterGroup = this.client.isPreviewing() ? this.client.getMeterGroupPreview() : this.client.getMeterGroup();
        for (Meter meter : meterGroup.getMeters()) {
            if (!meter.isIn((class_1937)this.minecraft.field_1687) || !predicate.test(meter)) continue;
            renderer.render(poses, bufferSource, meter);
        }
    }

    private boolean shouldRenderHighlight(Meter meter) {
        return switch ((MeterHighlightMode)Options.RedstoneMultimeter.RENDER_METERS.get()) {
            case MeterHighlightMode.ALWAYS -> true;
            case MeterHighlightMode.IN_FOCUS -> {
                if (this.client.isPreviewing() || !this.client.getHud().isFocusMode() || this.client.getHud().getFocussedMeter() == meter) {
                    yield true;
                }
                yield false;
            }
            case MeterHighlightMode.IN_FOCUS_MODE -> {
                if (!this.client.isPreviewing() && this.client.getHud().isFocusMode()) {
                    yield true;
                }
                yield false;
            }
            case MeterHighlightMode.NEVER -> false;
            default -> throw new IllegalStateException("unknown meter highlight mode " + Options.RedstoneMultimeter.RENDER_METERS.getAsString());
        };
    }

    private void renderHighlight(class_4587 poses, class_4597.class_4598 bufferSource, Meter meter) {
        class_2338 pos = meter.getPos().getBlockPos();
        int color = meter.getColor();
        boolean movable = meter.isMovable();
        class_4184 camera = this.minecraft.field_1773.method_19418();
        class_243 cameraPos = camera.method_19326();
        double dx = (double)pos.method_10263() - cameraPos.field_1352;
        double dy = (double)pos.method_10264() - cameraPos.field_1351;
        double dz = (double)pos.method_10260() - cameraPos.field_1350;
        int range = (Integer)Options.RedstoneMultimeter.METER_RANGE.get();
        double rangeSquared = range * range;
        if (range < 0 || class_3532.method_41190((double)dx, (double)dy, (double)dz) < rangeSquared) {
            int dim = this.getHighlightDimmingFactor(meter);
            poses.method_22903();
            poses.method_22904(dx, dy, dz);
            this.renderMeterHighlight(bufferSource, poses, ColorUtils.setAlpha(color, 127 / dim));
            if (movable) {
                this.renderMeterOutline(bufferSource, poses, ColorUtils.setAlpha(color, 255 / dim));
            }
            poses.method_22909();
        }
    }

    private int getHighlightDimmingFactor(Meter meter) {
        return this.shouldDimMeter(meter) ? 3 : 1;
    }

    private boolean shouldRenderNameTag(Meter meter) {
        return switch ((MeterNameTagMode)Options.RedstoneMultimeter.RENDER_METER_NAMES.get()) {
            case MeterNameTagMode.ALWAYS -> true;
            case MeterNameTagMode.IN_FOCUS_MODE -> {
                if (!this.client.isPreviewing() && this.client.getHud().isFocusMode()) {
                    yield true;
                }
                yield false;
            }
            case MeterNameTagMode.IN_FOCUS -> {
                if (!this.client.isPreviewing() && this.client.getHud().isFocusMode() && this.client.getHud().getFocussedMeter() == meter) {
                    yield true;
                }
                yield false;
            }
            case MeterNameTagMode.WHEN_PREVIEWING -> this.client.isPreviewing();
            case MeterNameTagMode.NEVER -> false;
            default -> throw new IllegalStateException("unknown meter name tag mode " + Options.RedstoneMultimeter.RENDER_METER_NAMES.getAsString());
        };
    }

    private void renderNameTag(class_4587 poses, class_4597.class_4598 bufferSource, Meter meter) {
        String name = meter.getName();
        class_2338 pos = meter.getPos().getBlockPos();
        class_4184 camera = this.minecraft.field_1773.method_19418();
        class_243 cameraPos = camera.method_19326();
        double dx = (double)pos.method_10263() - cameraPos.field_1352;
        double dy = (double)pos.method_10264() - cameraPos.field_1351;
        double dz = (double)pos.method_10260() - cameraPos.field_1350;
        int range = (Integer)Options.RedstoneMultimeter.METER_NAME_RANGE.get();
        double rangeSquared = range * range;
        if (class_3532.method_41190((double)dx, (double)dy, (double)dz) < rangeSquared) {
            int dim = this.getNameTagDimmingFactor(meter);
            poses.method_22903();
            poses.method_22904(dx + 0.5, dy + 0.75, dz + 0.5);
            poses.method_22907((Quaternionfc)camera.method_23767());
            poses.method_22905(0.025f, -0.025f, 0.025f);
            Matrix4f pose = poses.method_23760().method_23761();
            float x = -((float)this.minecraft.field_1772.method_1727(name) / 2.0f);
            float y = 0.0f;
            this.minecraft.field_1772.method_27521(name, x, y, ColorUtils.setAlpha(0xFFFFFF, 255 / dim), false, pose, (class_4597)bufferSource, class_327.class_6415.field_33994, 0, class_765.method_23687((int)15, (int)15));
            poses.method_22909();
        }
    }

    private int getNameTagDimmingFactor(Meter meter) {
        return this.shouldDimMeter(meter) ? 2 : 1;
    }

    private boolean shouldDimMeter(Meter meter) {
        return !this.client.isPreviewing() && this.client.getHud().isFocusMode() && this.client.getHud().getFocussedMeter() != meter;
    }

    private void renderMeterHighlight(class_4597.class_4598 bufferSource, class_4587 poses, int color) {
        class_4588 buffer = bufferSource.method_73477(class_1921.method_49042());
        Matrix4f pose = poses.method_23760().method_23761();
        float r = (float)ColorUtils.getRed(color) / 255.0f;
        float g = (float)ColorUtils.getGreen(color) / 255.0f;
        float b = (float)ColorUtils.getBlue(color) / 255.0f;
        float a = (float)ColorUtils.getAlpha(color) / 255.0f;
        this.drawBox(buffer, pose, r, g, b, a);
    }

    private void renderMeterOutline(class_4597.class_4598 bufferSource, class_4587 poses, int color) {
        class_4588 buffer = bufferSource.method_73477(class_1921.method_23594());
        class_9974.method_62296((class_4587)poses, (class_4588)buffer, (class_265)OUTLINE_SHAPE, (double)0.0, (double)0.0, (double)0.0, (int)color);
    }

    private void drawBox(class_4588 buffer, Matrix4f pose, float r, float g, float b, float a) {
        float c0 = -0.002f;
        float c1 = 1.002f;
        buffer.method_22918(pose, c0, c0, c0).method_22915(r, g, b, a);
        buffer.method_22918(pose, c0, c0, c1).method_22915(r, g, b, a);
        buffer.method_22918(pose, c0, c1, c1).method_22915(r, g, b, a);
        buffer.method_22918(pose, c0, c1, c0).method_22915(r, g, b, a);
        buffer.method_22918(pose, c1, c0, c0).method_22915(r, g, b, a);
        buffer.method_22918(pose, c1, c1, c0).method_22915(r, g, b, a);
        buffer.method_22918(pose, c1, c1, c1).method_22915(r, g, b, a);
        buffer.method_22918(pose, c1, c0, c1).method_22915(r, g, b, a);
        buffer.method_22918(pose, c0, c0, c0).method_22915(r, g, b, a);
        buffer.method_22918(pose, c0, c1, c0).method_22915(r, g, b, a);
        buffer.method_22918(pose, c1, c1, c0).method_22915(r, g, b, a);
        buffer.method_22918(pose, c1, c0, c0).method_22915(r, g, b, a);
        buffer.method_22918(pose, c0, c0, c1).method_22915(r, g, b, a);
        buffer.method_22918(pose, c1, c0, c1).method_22915(r, g, b, a);
        buffer.method_22918(pose, c1, c1, c1).method_22915(r, g, b, a);
        buffer.method_22918(pose, c0, c1, c1).method_22915(r, g, b, a);
        buffer.method_22918(pose, c0, c0, c0).method_22915(r, g, b, a);
        buffer.method_22918(pose, c1, c0, c0).method_22915(r, g, b, a);
        buffer.method_22918(pose, c1, c0, c1).method_22915(r, g, b, a);
        buffer.method_22918(pose, c0, c0, c1).method_22915(r, g, b, a);
        buffer.method_22918(pose, c0, c1, c0).method_22915(r, g, b, a);
        buffer.method_22918(pose, c0, c1, c1).method_22915(r, g, b, a);
        buffer.method_22918(pose, c1, c1, c1).method_22915(r, g, b, a);
        buffer.method_22918(pose, c1, c1, c0).method_22915(r, g, b, a);
    }

    @FunctionalInterface
    private static interface MeterPartRenderer {
        public void render(class_4587 var1, class_4597.class_4598 var2, Meter var3);
    }
}

