/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiFunction;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_3222;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;
import redstone.multimeter.client.gui.text.Text;
import redstone.multimeter.client.gui.text.Texts;
import redstone.multimeter.common.meter.MeterGroup;
import redstone.multimeter.interfaces.mixin.IMinecraftServer;
import redstone.multimeter.server.Multimeter;
import redstone.multimeter.server.MultimeterServer;
import redstone.multimeter.server.meter.ServerMeterGroup;

public class MeterGroupCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 buildContext) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"metergroup").requires(source -> MeterGroupCommand.isMultimeterClient(source))).then(class_2170.method_9247((String)"list").executes(context -> MeterGroupCommand.list((class_2168)context.getSource())))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"subscribe").executes(context -> MeterGroupCommand.subscribe((class_2168)context.getSource(), null))).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.greedyString()).suggests((context, suggestionsBuilder) -> class_2172.method_9265(MeterGroupCommand.listMeterGroups((class_2168)context.getSource()), (SuggestionsBuilder)suggestionsBuilder)).executes(context -> MeterGroupCommand.subscribe((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"name")))))).then(class_2170.method_9247((String)"unsubscribe").executes(context -> MeterGroupCommand.unsubscribe((class_2168)context.getSource())))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"private").requires(source -> MeterGroupCommand.isOwnerOfSubscription(source))).executes(context -> MeterGroupCommand.queryPrivate((class_2168)context.getSource()))).then(class_2170.method_9244((String)"private", (ArgumentType)BoolArgumentType.bool()).executes(context -> MeterGroupCommand.setPrivate((class_2168)context.getSource(), BoolArgumentType.getBool((CommandContext)context, (String)"private")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"members").requires(source -> MeterGroupCommand.isOwnerOfSubscription(source))).then(class_2170.method_9247((String)"list").executes(context -> MeterGroupCommand.membersList((class_2168)context.getSource())))).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).executes(context -> MeterGroupCommand.membersAdd((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player")))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"member", (ArgumentType)StringArgumentType.word()).suggests((context, suggestionsBuilder) -> class_2172.method_9265(MeterGroupCommand.listMembers((class_2168)context.getSource()).keySet(), (SuggestionsBuilder)suggestionsBuilder)).executes(context -> MeterGroupCommand.membersRemovePlayer((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"member")))))).then(class_2170.method_9247((String)"clear").executes(context -> MeterGroupCommand.membersClear((class_2168)context.getSource()))))).then(class_2170.method_9247((String)"clear").executes(context -> MeterGroupCommand.clear((class_2168)context.getSource())));
        dispatcher.register(builder);
    }

    private static boolean isMultimeterClient(class_2168 source) {
        return MeterGroupCommand.run(source, (multimeter, player) -> multimeter.getServer().isMultimeterClient((class_3222)player));
    }

    private static boolean isOwnerOfSubscription(class_2168 source) {
        return MeterGroupCommand.run(source, (multimeter, player) -> multimeter.isOwnerOfSubscription((class_3222)player));
    }

    private static Collection<String> listMeterGroups(class_2168 source) {
        ArrayList<String> names = new ArrayList<String>();
        MeterGroupCommand.command(source, (Multimeter multimeter, class_3222 player) -> {
            for (ServerMeterGroup meterGroup : multimeter.getMeterGroups()) {
                if (meterGroup.isPrivate() && !meterGroup.hasMember(player) && !meterGroup.isOwnedBy(player)) continue;
                names.add(meterGroup.getName());
            }
        });
        return names;
    }

    private static Map<String, UUID> listMembers(class_2168 source) {
        HashMap<String, UUID> names = new HashMap<String, UUID>();
        MeterGroupCommand.command(source, (Multimeter multimeter, class_3222 player) -> {
            ServerMeterGroup meterGroup = multimeter.getSubscription(player);
            if (meterGroup != null && meterGroup.isOwnedBy(player)) {
                for (UUID playerUUID : meterGroup.getMembers()) {
                    String playerName = multimeter.getServer().getPlayerList().getName(playerUUID);
                    if (playerName == null) continue;
                    names.put(playerName, playerUUID);
                }
            }
        });
        return names;
    }

    private static int list(class_2168 source) {
        Collection<String> names = MeterGroupCommand.listMeterGroups(source);
        if (names.isEmpty()) {
            MeterGroupCommand.sendSuccess(source, Texts.translatable("rsmm.command.metergroup.list.failure.none"));
        } else {
            Text message = Texts.translatable("rsmm.command.metergroup.list.success");
            for (String name : names) {
                message.append("\n  " + name);
            }
            MeterGroupCommand.sendSuccess(source, message);
        }
        return 1;
    }

    private static int subscribe(class_2168 source, String name) {
        return MeterGroupCommand.command(source, (Multimeter multimeter, class_3222 player) -> {
            if (name == null) {
                multimeter.subscribeToDefaultMeterGroup(player);
                MeterGroupCommand.sendSuccess(source, Texts.translatable("rsmm.command.metergroup.subscribe.success.default"));
            } else if (multimeter.hasMeterGroup(name)) {
                ServerMeterGroup meterGroup = multimeter.getMeterGroup(name);
                if (!meterGroup.isPrivate() || meterGroup.hasMember(player) || meterGroup.isOwnedBy(player)) {
                    multimeter.subscribeToMeterGroup(meterGroup, player);
                    MeterGroupCommand.sendSuccess(source, Texts.translatable("rsmm.command.metergroup.subscribe.success.joined", name));
                } else {
                    MeterGroupCommand.sendSuccess(source, Texts.translatable("rsmm.command.metergroup.subscribe.failure.private"));
                }
            } else if (MeterGroup.isValidName(name)) {
                multimeter.createMeterGroup(player, name);
                MeterGroupCommand.sendSuccess(source, Texts.translatable("rsmm.command.metergroup.subscribe.success.created", name));
            } else {
                MeterGroupCommand.sendSuccess(source, Texts.translatable("rsmm.command.metergroup.subscribe.failure.invalid", name));
            }
        });
    }

    private static int unsubscribe(class_2168 source) {
        return MeterGroupCommand.command(source, (Multimeter multimeter, ServerMeterGroup meterGroup, class_3222 player) -> {
            multimeter.unsubscribeFromMeterGroup(meterGroup, player);
            MeterGroupCommand.sendSuccess(source, Texts.translatable("rsmm.command.metergroup.unsubscribe.success", meterGroup.getName()));
        });
    }

    private static int queryPrivate(class_2168 source) {
        return MeterGroupCommand.command(source, (Multimeter multimeter, ServerMeterGroup meterGroup, class_3222 player) -> {
            String status = meterGroup.isPrivate() ? "private" : "public";
            MeterGroupCommand.sendSuccess(source, Texts.translatable("rsmm.command.metergroup.private.query.success." + status, meterGroup.getName()));
        });
    }

    private static int setPrivate(class_2168 source, boolean isPrivate) {
        return MeterGroupCommand.command(source, (Multimeter multimeter, ServerMeterGroup meterGroup, class_3222 player) -> {
            if (meterGroup.isOwnedBy(player)) {
                meterGroup.setPrivate(isPrivate);
                String status = isPrivate ? "private" : "public";
                MeterGroupCommand.sendSuccess(source, Texts.translatable("rsmm.command.metergroup.private.set.success." + status, meterGroup.getName()));
            } else {
                MeterGroupCommand.sendSuccess(source, Texts.translatable("rsmm.command.metergroup.private.set.failure.notOwner"));
            }
        });
    }

    private static int membersList(class_2168 source) {
        Map<String, UUID> members = MeterGroupCommand.listMembers(source);
        return MeterGroupCommand.commandMembers(source, (multimeter, meterGroup, owner) -> {
            if (members.isEmpty()) {
                MeterGroupCommand.sendSuccess(source, Texts.translatable("rsmm.command.metergroup.members.list.failure.none", meterGroup.getName()));
            } else {
                Text message = Texts.translatable("rsmm.command.metergroup.members.list.success", meterGroup.getName());
                for (Map.Entry member : members.entrySet()) {
                    message.append("\n  " + (String)member.getKey());
                }
                MeterGroupCommand.sendSuccess(source, message);
            }
        });
    }

    private static int membersAdd(class_2168 source, Collection<class_3222> players) {
        return MeterGroupCommand.commandMembers(source, (multimeter, meterGroup, owner) -> {
            for (class_3222 player : players) {
                if (player == owner) {
                    MeterGroupCommand.sendSuccess(source, Texts.translatable("rsmm.command.metergroup.members.add.failure.self"));
                    continue;
                }
                if (meterGroup.hasMember(player)) {
                    MeterGroupCommand.sendSuccess(source, Texts.translatable("rsmm.command.metergroup.members.add.failure.alreadyMember", player.method_5820(), meterGroup.getName()));
                    continue;
                }
                if (!multimeter.getServer().isMultimeterClient(player)) {
                    MeterGroupCommand.sendSuccess(source, Texts.translatable("rsmm.command.metergroup.members.add.failure.notInstalled", player.method_5820()));
                    continue;
                }
                multimeter.addMemberToMeterGroup(meterGroup, player.method_5667());
                MeterGroupCommand.sendSuccess(source, Texts.translatable("rsmm.command.metergroup.members.add.success", player.method_5820(), meterGroup.getName()));
            }
        });
    }

    private static int membersRemovePlayer(class_2168 source, String playerName) {
        return MeterGroupCommand.commandMembers(source, (multimeter, meterGroup, owner) -> {
            Map.Entry<String, UUID> member = MeterGroupCommand.findMember(MeterGroupCommand.listMembers(source), playerName);
            if (member == null) {
                class_3222 player = multimeter.getServer().getPlayerList().get(playerName);
                if (player == owner) {
                    MeterGroupCommand.sendSuccess(source, Texts.translatable("rsmm.command.metergroup.members.remove.failure.self"));
                } else {
                    MeterGroupCommand.sendSuccess(source, Texts.translatable("rsmm.command.metergroup.members.remove.failure.noSuchMember", meterGroup.getName(), playerName));
                }
            } else {
                multimeter.removeMemberFromMeterGroup(meterGroup, member.getValue());
                MeterGroupCommand.sendSuccess(source, Texts.translatable("rsmm.command.metergroup.members.remove.success", member.getKey(), meterGroup.getName()));
            }
        });
    }

    private static Map.Entry<String, UUID> findMember(Map<String, UUID> members, String playerName) {
        String key = playerName.toLowerCase();
        for (Map.Entry<String, UUID> member : members.entrySet()) {
            if (!member.getKey().toLowerCase().equals(key)) continue;
            return member;
        }
        return null;
    }

    private static int membersClear(class_2168 source) {
        return MeterGroupCommand.commandMembers(source, (multimeter, meterGroup, owner) -> {
            multimeter.clearMembersOfMeterGroup(meterGroup);
            MeterGroupCommand.sendSuccess(source, Texts.translatable("rsmm.command.metergroup.members.clear.success", meterGroup.getName()));
        });
    }

    private static int commandMembers(class_2168 source, MeterGroupCommandExecutor command) {
        return MeterGroupCommand.command(source, (Multimeter multimeter, ServerMeterGroup meterGroup, class_3222 player) -> {
            if (meterGroup.isOwnedBy(player)) {
                command.run(multimeter, meterGroup, player);
                if (!meterGroup.isPrivate()) {
                    MeterGroupCommand.sendSuccess(source, Texts.translatable("rsmm.command.metergroup.members.warning.public"));
                }
            }
        });
    }

    private static int clear(class_2168 source) {
        return MeterGroupCommand.command(source, (Multimeter multimeter, ServerMeterGroup meterGroup, class_3222 player) -> {
            multimeter.clearMeterGroup(meterGroup);
            MeterGroupCommand.sendSuccess(source, Texts.translatable("rsmm.command.metergroup.clear.success", meterGroup.getName()));
        });
    }

    private static int command(class_2168 source, MeterGroupCommandExecutor command) {
        return MeterGroupCommand.command(source, (Multimeter multimeter, class_3222 player) -> {
            ServerMeterGroup meterGroup = multimeter.getSubscription(player);
            if (meterGroup == null) {
                MeterGroupCommand.sendSuccess(source, Texts.translatable("rsmm.command.metergroup.warning.notSubscribed"));
            } else {
                command.run(multimeter, meterGroup, player);
            }
        });
    }

    private static int command(class_2168 source, MultimeterCommandExecutor command) {
        return MeterGroupCommand.run(source, (m, p) -> {
            command.run((Multimeter)m, (class_3222)p);
            return true;
        }) ? 1 : 0;
    }

    private static boolean run(class_2168 source, BiFunction<Multimeter, class_3222, Boolean> command) {
        class_3222 player = source.method_44023();
        MinecraftServer server = source.method_9211();
        MultimeterServer multimeterServer = ((IMinecraftServer)server).getMultimeterServer();
        Multimeter multimeter = multimeterServer.getMultimeter();
        return command.apply(multimeter, player);
    }

    private static void sendSuccess(class_2168 source, Text message) {
        MeterGroupCommand.sendSuccess(source, message, false);
    }

    private static void sendSuccess(class_2168 source, Text message, boolean actionBar) {
        source.method_9226(message::resolve, actionBar);
    }

    @FunctionalInterface
    private static interface MultimeterCommandExecutor {
        public void run(Multimeter var1, class_3222 var2);
    }

    @FunctionalInterface
    private static interface MeterGroupCommandExecutor {
        public void run(Multimeter var1, ServerMeterGroup var2, class_3222 var3);
    }
}

