/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.common.network.packets;

import net.minecraft.class_2487;
import net.minecraft.class_3222;
import redstone.multimeter.client.MultimeterClient;
import redstone.multimeter.client.meter.ClientMeterGroup;
import redstone.multimeter.common.network.RSMMPacket;
import redstone.multimeter.server.Multimeter;
import redstone.multimeter.server.MultimeterServer;
import redstone.multimeter.server.meter.ServerMeterGroup;

public class MeterGroupSubscriptionPacket
implements RSMMPacket {
    private String name;
    private boolean subscribe;

    public MeterGroupSubscriptionPacket() {
    }

    public MeterGroupSubscriptionPacket(String name, boolean subscribed) {
        this.name = name;
        this.subscribe = subscribed;
    }

    @Override
    public void encode(class_2487 data) {
        data.method_10582("name", this.name);
        data.method_10556("subscribe", this.subscribe);
    }

    @Override
    public void decode(class_2487 data) {
        this.name = (String)data.method_10558("name").get();
        this.subscribe = (Boolean)data.method_10577("subscribe").get();
    }

    @Override
    public void handle(MultimeterServer server, class_3222 player) {
        Multimeter multimeter = server.getMultimeter();
        ServerMeterGroup meterGroup = multimeter.getMeterGroup(this.name);
        if (this.subscribe) {
            if (meterGroup == null) {
                multimeter.createMeterGroup(player, this.name);
            } else {
                multimeter.subscribeToMeterGroup(meterGroup, player);
            }
        } else if (meterGroup == null) {
            multimeter.refreshMeterGroup(player);
        } else {
            multimeter.unsubscribeFromMeterGroup(meterGroup, player);
        }
    }

    @Override
    public void handle(MultimeterClient client) {
        ClientMeterGroup meterGroup = client.getMeterGroup();
        ClientMeterGroup meterGroupPreview = client.getMeterGroupPreview();
        if (this.subscribe) {
            client.handleSubscribeToMeterGroup(this.name);
        } else {
            meterGroup.unsubscribe(false);
        }
        meterGroupPreview.stopPreviewing();
        if (client.getHud().isFocusMode()) {
            client.getHud().setFocusMode(false);
        }
    }
}

