/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.common.network.packets;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import redstone.multimeter.client.MultimeterClient;
import redstone.multimeter.common.meter.MeterProperties;
import redstone.multimeter.common.network.RSMMPacket;
import redstone.multimeter.server.MultimeterServer;
import redstone.multimeter.util.NbtUtils;

public class MeterUpdatesPacket
implements RSMMPacket {
    private List<Long> removedMeters;
    private Long2ObjectMap<MeterProperties> meterUpdates;
    private List<Long> meters;

    public MeterUpdatesPacket() {
        this.removedMeters = new ArrayList<Long>();
        this.meterUpdates = new Long2ObjectOpenHashMap();
        this.meters = new ArrayList<Long>();
    }

    public MeterUpdatesPacket(List<Long> removedMeters, Map<Long, MeterProperties> updates, List<Long> meters) {
        this.removedMeters = new ArrayList<Long>(removedMeters);
        this.meterUpdates = new Long2ObjectOpenHashMap(updates);
        this.meters = new ArrayList<Long>(meters);
    }

    @Override
    public void encode(class_2487 data) {
        if (!this.removedMeters.isEmpty()) {
            data.method_10564("removed", NbtUtils.toLongArray(this.removedMeters));
        }
        if (!this.meterUpdates.isEmpty()) {
            class_2499 list = new class_2499();
            for (Long2ObjectMap.Entry entry : this.meterUpdates.long2ObjectEntrySet()) {
                long id = entry.getLongKey();
                MeterProperties update = (MeterProperties)entry.getValue();
                class_2487 nbt = update.toNbt();
                nbt.method_10544("id", id);
                list.add((Object)nbt);
            }
            data.method_10566("updates", (class_2520)list);
        }
        if (!this.meters.isEmpty()) {
            data.method_10564("meters", NbtUtils.toLongArray(this.meters));
        }
    }

    @Override
    public void decode(class_2487 data) {
        if (data.method_10545("removed")) {
            long[] removed;
            for (long id : removed = (long[])data.method_10565("removed").get()) {
                this.removedMeters.add(id);
            }
        }
        if (data.method_10545("updates")) {
            class_2499 updates = (class_2499)data.method_10554("updates").get();
            for (int i = 0; i < updates.size(); ++i) {
                class_2487 nbt = (class_2487)updates.method_10602(i).get();
                long id = (Long)nbt.method_10537("id").get();
                MeterProperties update = MeterProperties.fromNbt(nbt);
                this.meterUpdates.put(id, (Object)update);
            }
        }
        if (data.method_10545("meters")) {
            long[] ids;
            for (long id : ids = (long[])data.method_10565("meters").get()) {
                this.meters.add(id);
            }
        }
    }

    @Override
    public void handle(MultimeterServer server, class_3222 player) {
    }

    @Override
    public void handle(MultimeterClient client) {
        client.getMeterGroup().updateMeters(this.removedMeters, this.meterUpdates, this.meters);
    }
}

