/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.registry;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_2960;

public class SupplierRegistry<T> {
    private final class_2960 key;
    private final Map<Class<? extends T>, class_2960> byKey;
    private final Map<class_2960, Supplier<? extends T>> keys;

    public SupplierRegistry(String name) {
        this(class_2960.method_60655((String)"redstone_multimeter", (String)name));
    }

    public SupplierRegistry(class_2960 key) {
        this.key = key;
        this.byKey = new HashMap<Class<? extends T>, class_2960>();
        this.keys = new HashMap<class_2960, Supplier<? extends T>>();
    }

    public class_2960 getRegistryKey() {
        return this.key;
    }

    public T get(class_2960 key) {
        Supplier<? extends T> supplier = this.keys.get(key);
        return supplier == null ? null : (T)supplier.get();
    }

    public class_2960 getKey(T obj) {
        return this.byKey.get(obj.getClass());
    }

    public <P extends T> void register(String name, Class<P> type, Supplier<P> supplier) {
        String namespace = this.key.method_12836();
        String path = String.format("%s/%s", this.key.method_12832(), name);
        class_2960 key = class_2960.method_60655((String)namespace, (String)path);
        if (this.byKey.containsKey(type)) {
            throw new IllegalStateException("Registry " + String.valueOf(this.key) + " already registered an entry with type " + String.valueOf(type));
        }
        if (this.keys.containsKey(key)) {
            throw new IllegalStateException("Registry " + String.valueOf(this.key) + " already registered an entry with key " + String.valueOf(key));
        }
        this.byKey.put(type, key);
        this.keys.put(key, supplier);
    }
}

