/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.server;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_1937;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_8710;
import redstone.multimeter.common.network.PacketWrapper;
import redstone.multimeter.common.network.RSMMPacket;
import redstone.multimeter.server.MultimeterServer;
import redstone.multimeter.server.meter.ServerMeterGroup;

public class PlayerList {
    private final MultimeterServer server;
    private final Map<UUID, class_3222> playersByUuid;
    private final Map<String, class_3222> playersByName;
    private final Map<UUID, String> nameCache;

    public PlayerList(MultimeterServer server) {
        this.server = server;
        this.playersByUuid = new HashMap<UUID, class_3222>();
        this.playersByName = new HashMap<String, class_3222>();
        this.nameCache = new HashMap<UUID, String>();
    }

    public MultimeterServer getServer() {
        return this.server;
    }

    public void tick() {
        if (this.server.getTickCount() % 72000L == 0L) {
            this.cleanNameCache();
        }
    }

    private void cleanNameCache() {
        Collection<ServerMeterGroup> meterGroups = this.server.getMultimeter().getMeterGroups();
        this.nameCache.keySet().removeIf(uuid -> {
            for (ServerMeterGroup meterGroup : meterGroups) {
                if (!meterGroup.hasMember((UUID)uuid)) continue;
                return false;
            }
            return true;
        });
    }

    public void add(class_3222 player) {
        if (!this.has(player.method_5667())) {
            this.playersByUuid.put(player.method_5667(), player);
            this.playersByName.put(player.method_5820(), player);
            this.nameCache.remove(player.method_5667());
            this.server.onPlayerJoin(player);
        }
    }

    public void remove(class_3222 player) {
        if (this.has(player.method_5667())) {
            this.playersByUuid.remove(player.method_5667());
            this.playersByName.remove(player.method_5820());
            this.nameCache.put(player.method_5667(), player.method_5820());
            this.server.onPlayerLeave(player);
        }
    }

    public void respawn(class_3222 player) {
        if (this.has(player.method_5667())) {
            this.playersByUuid.put(player.method_5667(), player);
            this.playersByName.put(player.method_5820(), player);
        }
    }

    public Collection<class_3222> get() {
        return this.playersByUuid.values();
    }

    public class_3222 get(UUID uuid) {
        return this.playersByUuid.get(uuid);
    }

    public class_3222 get(String name) {
        return this.playersByName.get(name);
    }

    public boolean has(UUID uuid) {
        return this.playersByUuid.containsKey(uuid);
    }

    public boolean has(String name) {
        return this.playersByName.containsKey(name);
    }

    public String getName(UUID uuid) {
        class_3222 player = this.get(uuid);
        return player == null ? this.nameCache.get(uuid) : player.method_5820();
    }

    public void send(RSMMPacket packet) {
        this.send(packet, (class_3222 player) -> true);
    }

    public void send(RSMMPacket packet, ServerMeterGroup meterGroup) {
        this.send(packet, (class_3222 player) -> meterGroup.hasSubscriber((class_3222)player));
    }

    public void send(RSMMPacket packet, class_5321<class_1937> dimension) {
        this.send(packet, (class_3222 player) -> player.method_51469().method_27983() == dimension);
    }

    public void send(RSMMPacket packet, Predicate<class_3222> predicate) {
        class_2596<?> mcPacket = this.wrap(packet);
        for (class_3222 player : this.playersByUuid.values()) {
            if (!predicate.test(player)) continue;
            player.field_13987.method_14364(mcPacket);
        }
    }

    public void send(RSMMPacket packet, class_3222 player) {
        player.field_13987.method_14364(this.wrap(packet));
    }

    private class_2596<?> wrap(RSMMPacket packet) {
        return new class_2658((class_8710)new PacketWrapper(packet));
    }

    public void updatePermissions(class_3222 player) {
        this.server.getMinecraftServer().method_3760().method_14576(player);
    }
}

