/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.server.meter.log;

import it.unimi.dsi.fastutil.longs.Long2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import redstone.multimeter.common.TickPhase;
import redstone.multimeter.common.meter.Meter;
import redstone.multimeter.common.meter.event.MeterEvent;
import redstone.multimeter.common.meter.log.EventLog;
import redstone.multimeter.common.meter.log.LogManager;
import redstone.multimeter.common.network.RSMMPacket;
import redstone.multimeter.common.network.packets.MeterLogsPacket;
import redstone.multimeter.server.meter.ServerMeterGroup;

public class ServerLogManager
extends LogManager {
    private final ServerMeterGroup meterGroup;
    private final Long2IntMap subticks;
    private long cutoff;
    private int unsentLogs;

    public ServerLogManager(ServerMeterGroup meterGroup) {
        this.meterGroup = meterGroup;
        this.subticks = new Long2IntLinkedOpenHashMap();
        this.cutoff = -1L;
    }

    @Override
    protected ServerMeterGroup getMeterGroup() {
        return this.meterGroup;
    }

    @Override
    public void clearLogs() {
        super.clearLogs();
        this.subticks.clear();
        this.cutoff = -1L;
        this.unsentLogs = 0;
    }

    public void tick() {
        this.cutoff = Long.MAX_VALUE;
        for (class_1937 class_19372 : this.meterGroup.getMultimeter().getServer().getLevels()) {
            long gameTime = class_19372.method_8510();
            if (gameTime >= this.cutoff) continue;
            this.cutoff = gameTime;
        }
        this.subticks.keySet().removeIf(time -> time < this.cutoff);
    }

    private int nextSubtick(long tick) {
        return this.subticks.compute(tick, (key, value) -> {
            int n;
            if (value == null) {
                n = 0;
            } else {
                value = value + 1;
                n = value;
            }
            return n;
        });
    }

    public void logEvent(class_1937 level, Meter meter, MeterEvent event) {
        long tick = level.method_8510();
        int subtick = this.nextSubtick(tick);
        TickPhase phase = this.meterGroup.getMultimeter().getServer().getTickPhase();
        meter.getLogs().add(new EventLog(tick, subtick, phase, event));
        ++this.unsentLogs;
    }

    public void broadcastLogs() {
        if (this.unsentLogs == 0) {
            return;
        }
        class_2499 list = new class_2499();
        for (Meter meter : this.meterGroup.getMeters()) {
            if (meter.getLogs().isEmpty()) continue;
            long id = meter.getId();
            class_2487 logs = meter.getLogs().toNbt();
            class_2487 nbt = new class_2487();
            nbt.method_10544("id", id);
            nbt.method_10566("logs", (class_2520)logs);
            nbt.method_10556("powered", meter.isPowered());
            nbt.method_10556("active", meter.isActive());
            list.add((Object)nbt);
            meter.getLogs().clear();
        }
        if (list.isEmpty()) {
            return;
        }
        MeterLogsPacket packet = new MeterLogsPacket(list);
        this.meterGroup.getMultimeter().getServer().getPlayerList().send((RSMMPacket)packet, this.meterGroup);
        this.unsentLogs = 0;
    }
}

