/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.util;

public class ColorUtils {
    public static int getAlpha(int argb) {
        return argb >> 24 & 0xFF;
    }

    public static int getRed(int argb) {
        return argb >> 16 & 0xFF;
    }

    public static int getGreen(int argb) {
        return argb >> 8 & 0xFF;
    }

    public static int getBlue(int argb) {
        return argb & 0xFF;
    }

    public static int fromAlpha(int alpha) {
        return (alpha & 0xFF) << 24;
    }

    public static int fromRed(int red) {
        return (red & 0xFF) << 16;
    }

    public static int fromGreen(int green) {
        return (green & 0xFF) << 8;
    }

    public static int fromBlue(int blue) {
        return blue & 0xFF;
    }

    public static int setAlpha(int color, int alpha) {
        return color & 0xFFFFFF | alpha << 24;
    }

    public static int setRed(int color, int red) {
        return color & 0xFF00FFFF | red << 16;
    }

    public static int setGreen(int color, int green) {
        return color & 0xFFFF00FF | green << 8;
    }

    public static int setBlue(int color, int blue) {
        return color & 0xFFFFFF00 | blue;
    }

    public static int fromRGB(int red, int green, int blue) {
        return ColorUtils.fromRed(red) | ColorUtils.fromGreen(green) | ColorUtils.fromBlue(blue);
    }

    public static int fromARGB(int alpha, int red, int green, int blue) {
        return ColorUtils.fromARGB(alpha, ColorUtils.fromRGB(red, green, blue));
    }

    public static int fromARGB(int alpha, int rgb) {
        return ColorUtils.fromAlpha(alpha) | rgb;
    }

    public static int fromRGBString(String string) {
        if (string.length() > 6) {
            throw new NumberFormatException("Too many characters!");
        }
        return Integer.valueOf(string, 16);
    }

    public static int fromARGBString(String string) {
        if (string.length() > 8) {
            throw new NumberFormatException("Too many characters!");
        }
        return Integer.valueOf(string, 16);
    }

    public static String toRGBString(int color) {
        Object hex = Integer.toHexString(color & 0xFFFFFF);
        while (((String)hex).length() < 6) {
            hex = "0" + (String)hex;
        }
        return ((String)hex).toUpperCase();
    }

    public static String toARGBString(int color) {
        Object hex = Integer.toHexString(color & 0xFFFFFFFF);
        while (((String)hex).length() < 8) {
            hex = "0" + (String)hex;
        }
        return ((String)hex).toUpperCase();
    }
}

