/*
 * Decompiled with CFR 0.152.
 */
package io.github.crazysmc.thrkbs;

import it.unimi.dsi.fastutil.chars.Char2CharMap;
import it.unimi.dsi.fastutil.chars.Char2CharOpenHashMap;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DynamicTextReplacer {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Pattern F3_PLUS_KEY = Pattern.compile("F(?:3| III) \\+ (?:F IV|F VI?|\u00c9?\\w+)");
    private static final Pattern F3_PLUS_KEY_CN = Pattern.compile("F3\u4e26\\w+");
    private static final Pattern F3_PLUS_KEY_UD = Pattern.compile("[^ ]+ \\+ \u0190\u2132?");
    private static final Char2CharMap CHAR_MAP_UD = new Char2CharOpenHashMap(new char[]{'!', '\"', '&', '\'', '(', ')', ',', '.', '1', '2', '3', '4', '5', '6', '7', '9', ';', '<', '>', '?', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'J', 'K', 'L', 'M', 'P', 'Q', 'R', 'T', 'U', 'V', 'W', 'Y', '[', ']', '_', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'p', 'q', 'r', 't', 'u', 'v', 'w', 'y', '{', '}'}, new char[]{'\u00a1', '\u201e', '\u214b', ',', ')', '(', '\u2018', '\u02d9', '\u295d', '\u1614', '\u0190', '\u07c8', '\u03db', '9', '\u3125', '6', '\u2e35', '>', '<', '\u00bf', '\u2c6f', '\u15fa', '\u0186', '\u15e1', '\u018e', '\u2132', '\u2141', '\u0550', '\ua7b0', '\ua780', 'W', '\u0500', '\ua779', '\u1d1a', '\u27d8', '\u2229', '\u0245', 'M', '\u2144', ']', '[', '\u203e', '\u0250', 'q', '\u0254', 'p', '\u01dd', '\u025f', '\u1d77', '\u0265', '\u1d09', '\u027e', '\u029e', '\ua781', '\u026f', 'u', 'd', 'b', '\u0279', '\u0287', 'n', '\u028c', '\u028d', '\u028e', '}', '{'});

    public static String keyBinding(String key) {
        if (key.length() == 1) {
            key = key.toUpperCase(Locale.ROOT);
        }
        return key;
    }

    public static String debugHelpMessage(String text, String f3, String key) {
        Matcher matcher;
        boolean keyLetter;
        boolean f3Letter = f3.length() == 1;
        boolean bl = keyLetter = key.length() == 1;
        if (f3Letter) {
            f3 = f3.toUpperCase(Locale.ROOT);
        }
        if (keyLetter) {
            key = key.toUpperCase(Locale.ROOT);
        }
        if ((matcher = F3_PLUS_KEY.matcher(text)).find()) {
            return matcher.replaceAll(String.format("%s + %s", f3, key));
        }
        Matcher matcherUd = F3_PLUS_KEY_UD.matcher(text);
        if (matcherUd.find()) {
            if (f3Letter) {
                f3 = DynamicTextReplacer.upsideDown(f3);
            }
            if (keyLetter) {
                key = DynamicTextReplacer.upsideDown(key);
            }
            return matcherUd.replaceAll(String.format("%s + %s", key, f3));
        }
        Matcher matcherCn = F3_PLUS_KEY_CN.matcher(text);
        if (matcherCn.find()) {
            return matcherCn.replaceAll(String.format("%s\u4e26%s", f3, key));
        }
        LOGGER.warn("could not find F3 key combination in '{}'", (Object)text);
        return text;
    }

    public static String debugCharts(String text, String f3, String chart1, String chart2, String chart3) {
        f3 = DynamicTextReplacer.keyBinding(f3).replace(" ", "");
        return text.replace("[F3+1]", String.format("[%s+%s]", f3, DynamicTextReplacer.keyBinding(chart1).replace(" ", ""))).replace("[F3+2]", String.format("[%s+%s]", f3, DynamicTextReplacer.keyBinding(chart2).replace(" ", ""))).replace("[F3+3]", String.format("[%s+%s]", f3, DynamicTextReplacer.keyBinding(chart3).replace(" ", "")));
    }

    private static String upsideDown(String string) {
        char c = string.charAt(0);
        return String.valueOf(CHAR_MAP_UD.getOrDefault(c, c));
    }
}

