/*
 * Decompiled with CFR 0.152.
 */
package io.github.crazysmc.thrkbs;

import io.github.crazysmc.thrkbs.MappingCategory;
import io.github.crazysmc.thrkbs.ThoroughKeybindings;
import io.github.crazysmc.thrkbs.Versions;
import java.util.Arrays;
import java.util.stream.Stream;

public enum HardcodedMapping {
    GAME_MENU(MappingCategory.MISC, 256, "gameMenu", "pause", true),
    TOGGLE_GUI(MappingCategory.MISC, 290, "toggleGui", ThoroughKeybindings.NO_DEBUG_BINDS),
    DEBUG_INFO(MappingCategory.MISC, 292, "debug.modifier", ThoroughKeybindings.NO_DEBUG_BINDS),
    TOGGLE_SHADER(MappingCategory.MISC, 293, "toggleSpectatorShaderEffects", ThoroughKeybindings.MC_VERSION.compareTo((Object)Versions.V20W20A) < 0),
    GAME_MODE(MappingCategory.MISC, 293, "switchGameMode", "gamemodes", ThoroughKeybindings.MC_VERSION.compareTo((Object)Versions.V20W20A) >= 0 && ThoroughKeybindings.NO_DEBUG_BINDS),
    DEBUG_OPTIONS(MappingCategory.MISC, ThoroughKeybindings.MC_VERSION.compareTo((Object)Versions.V12109PRE4) < 0 ? 294 : 295, "debug.debugOptions", "options", ThoroughKeybindings.MC_VERSION.compareTo((Object)Versions.V25W31A) >= 0 && ThoroughKeybindings.NO_DEBUG_BINDS),
    NARRATOR(MappingCategory.MISC, 66, "narrator", !ThoroughKeybindings.NO_DEBUG_BINDS),
    CHARTS_PROFILER(MappingCategory.DEBUG, 49, "profilingChart", "charts.profiler", ThoroughKeybindings.MC_VERSION.compareTo((Object)Versions.V23W33A) >= 0 && ThoroughKeybindings.NO_DEBUG_BINDS),
    CHARTS_FPS(MappingCategory.DEBUG, 50, "fpsCharts", "charts.fps", ThoroughKeybindings.MC_VERSION.compareTo((Object)Versions.V23W33A) >= 0 && ThoroughKeybindings.NO_DEBUG_BINDS),
    CHARTS_NETWORK(MappingCategory.DEBUG, 51, "networkCharts", "charts.network", ThoroughKeybindings.MC_VERSION.compareTo((Object)Versions.V23W33A) >= 0 && ThoroughKeybindings.NO_DEBUG_BINDS),
    RELOAD_CHUNKS(MappingCategory.DEBUG, 65, "reloadChunk", "reload_chunks", ThoroughKeybindings.NO_DEBUG_BINDS),
    SHOW_HITBOXES(MappingCategory.DEBUG, 66, "showHitboxes", "show_hitboxes", ThoroughKeybindings.NO_DEBUG_BINDS),
    COPY_LOCATION(MappingCategory.DEBUG, 67, "copyLocation", "copy_location", ThoroughKeybindings.NO_DEBUG_BINDS),
    CLEAR_CHAT(MappingCategory.DEBUG, 68, "clearChat", "clear_chat", ThoroughKeybindings.NO_DEBUG_BINDS),
    RENDER_DISTANCE(MappingCategory.DEBUG, 70, "cycleRenderDistance", "cycle_renderdistance", ThoroughKeybindings.MC_VERSION.compareTo((Object)Versions.V22W12A) < 0),
    CHUNK_BOUNDARIES(MappingCategory.DEBUG, 71, "showChunkBorders", "chunk_boundaries", ThoroughKeybindings.NO_DEBUG_BINDS),
    ADVANCED_TOOLTIPS(MappingCategory.DEBUG, 72, "showAdvancedTooltips", "advanced_tooltips", ThoroughKeybindings.NO_DEBUG_BINDS),
    INSPECT(MappingCategory.DEBUG, 73, "copyRecreateCommand", "inspect", ThoroughKeybindings.NO_DEBUG_BINDS),
    PROFILING(MappingCategory.DEBUG, 76, "profiling", "profiling", ThoroughKeybindings.MC_VERSION.compareTo((Object)Versions.V21W11A) >= 0 && ThoroughKeybindings.NO_DEBUG_BINDS),
    SPECTATE(MappingCategory.DEBUG, 78, "spectate", "creative_spectator", ThoroughKeybindings.NO_DEBUG_BINDS),
    FOCUS_PAUSE(MappingCategory.DEBUG, 80, "focusPause", "pause_focus", ThoroughKeybindings.NO_DEBUG_BINDS),
    HELP(MappingCategory.DEBUG, 81, "help", "help", ThoroughKeybindings.NO_DEBUG_BINDS),
    DUMP_DYN_TEX(MappingCategory.DEBUG, 83, "dumpDynamicTextures", "dump_dynamic_textures", ThoroughKeybindings.MC_VERSION.compareTo((Object)Versions.V11904PRE3) >= 0 && ThoroughKeybindings.NO_DEBUG_BINDS),
    RELOAD_RESOURCE_PACKS(MappingCategory.DEBUG, 84, "reloadResourcePacks", "reload_resourcepacks", ThoroughKeybindings.NO_DEBUG_BINDS),
    DUMP_VERSION(MappingCategory.DEBUG, 86, "dumpVersion", "version", ThoroughKeybindings.MC_VERSION.compareTo((Object)Versions.V25W15A) >= 0 && ThoroughKeybindings.NO_DEBUG_BINDS),
    SHIFT_1(MappingCategory.MODIFIER, 340, "mod.shift.1"),
    SHIFT_2(MappingCategory.MODIFIER, 344, "mod.shift.2"),
    CTRL_1(MappingCategory.MODIFIER, ThoroughKeybindings.ON_OSX && ThoroughKeybindings.NO_DEBUG_BINDS ? 343 : 341, "mod.ctrl.1"),
    CTRL_2(MappingCategory.MODIFIER, ThoroughKeybindings.ON_OSX && ThoroughKeybindings.NO_DEBUG_BINDS ? 347 : 345, "mod.ctrl.2"),
    ALT_1(MappingCategory.MODIFIER, 342, "mod.alt.1"),
    ALT_2(MappingCategory.MODIFIER, 346, "mod.alt.2"),
    PROFILER_0(MappingCategory.PROFILER, 48, "profiler.up"),
    PROFILER_1(MappingCategory.PROFILER, 49, "profiler.1"),
    PROFILER_2(MappingCategory.PROFILER, 50, "profiler.2"),
    PROFILER_3(MappingCategory.PROFILER, 51, "profiler.3"),
    PROFILER_4(MappingCategory.PROFILER, 52, "profiler.4"),
    PROFILER_5(MappingCategory.PROFILER, 53, "profiler.5"),
    PROFILER_6(MappingCategory.PROFILER, 54, "profiler.6"),
    PROFILER_7(MappingCategory.PROFILER, 55, "profiler.7"),
    PROFILER_8(MappingCategory.PROFILER, 56, "profiler.8"),
    PROFILER_9(MappingCategory.PROFILER, 57, "profiler.9");

    private final MappingCategory category;
    private final int keyCode;
    private final String name;
    private final String debugHelp;
    private final boolean exists;

    private HardcodedMapping(MappingCategory category, int keyCode, String name) {
        this(category, keyCode, name, null, true);
    }

    private HardcodedMapping(MappingCategory category, int keyCode, String name, boolean exists) {
        this(category, keyCode, name, null, exists);
    }

    private HardcodedMapping(MappingCategory category, int keyCode, String name, String debugHelp, boolean exists) {
        this.category = category;
        this.keyCode = keyCode;
        this.name = category == MappingCategory.DEBUG ? String.format("debug.%s", name) : name;
        this.debugHelp = debugHelp;
        this.exists = exists;
    }

    public static Stream<HardcodedMapping> getExisting() {
        return Arrays.stream(HardcodedMapping.values()).filter(mapping -> mapping.exists);
    }

    public MappingCategory getCategory() {
        return this.category;
    }

    public int getKeyCode() {
        return this.keyCode;
    }

    public String getId() {
        return String.format("key.%s", this.name);
    }

    public String getDebugHelpId() {
        return this.debugHelp == null ? null : String.format("debug.%s.help", this.debugHelp);
    }
}

