/*
 * Decompiled with CFR 0.152.
 */
package io.github.crazysmc.thrkbs;

import io.github.crazysmc.thrkbs.HardcodedMapping;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;

public class RemapRegistry<T> {
    private final int CAPACITY = HardcodedMapping.values().length;
    private final EnumMap<HardcodedMapping, T> BY_MAPPING = new EnumMap(HardcodedMapping.class);
    private final Int2ObjectMap<T> BY_DEFAULT_KEY_CODE = new Int2ObjectOpenHashMap(this.CAPACITY);
    private final Map<String, T> BY_DEBUG_HELP = new HashMap<String, T>(this.CAPACITY);

    public void register(HardcodedMapping mapping, T remapping) {
        this.BY_MAPPING.put(mapping, remapping);
        this.BY_DEFAULT_KEY_CODE.put(mapping.getKeyCode(), remapping);
        String debugHelp = mapping.getDebugHelpId();
        if (debugHelp != null) {
            this.BY_DEBUG_HELP.put(debugHelp, remapping);
        }
    }

    public T get(HardcodedMapping mapping) {
        return this.BY_MAPPING.get((Object)mapping);
    }

    public int size() {
        return this.BY_MAPPING.size();
    }

    public T getByDefault(int keyCode) {
        return (T)this.BY_DEFAULT_KEY_CODE.get(keyCode);
    }

    public T getByDebugHelp(String debugHelp) {
        return this.BY_DEBUG_HELP.get(debugHelp);
    }

    public Collection<T> getDebugKeys() {
        return Collections.unmodifiableCollection(this.BY_DEBUG_HELP.values());
    }
}

