/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ftm2.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.ftm2.Ftm2Mod;
import net.mcreator.ftm2.procedures.MeltingMachineConfigChangeProcedure;
import net.mcreator.ftm2.procedures.MeltingMachineMoldConfigChangeProcedure;
import net.mcreator.ftm2.world.inventory.MeltingMachineGUIMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class MeltingMachineGUISlotMessage {
    private final int slotID;
    private final int x;
    private final int y;
    private final int z;
    private final int changeType;
    private final int meta;

    public MeltingMachineGUISlotMessage(int slotID, int x, int y, int z, int changeType, int meta) {
        this.slotID = slotID;
        this.x = x;
        this.y = y;
        this.z = z;
        this.changeType = changeType;
        this.meta = meta;
    }

    public MeltingMachineGUISlotMessage(FriendlyByteBuf buffer) {
        this.slotID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
        this.changeType = buffer.readInt();
        this.meta = buffer.readInt();
    }

    public static void buffer(MeltingMachineGUISlotMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.slotID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
        buffer.writeInt(message.changeType);
        buffer.writeInt(message.meta);
    }

    public static void handler(MeltingMachineGUISlotMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int slotID = message.slotID;
            int changeType = message.changeType;
            int meta = message.meta;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            MeltingMachineGUISlotMessage.handleSlotAction((Player)entity, slotID, changeType, meta, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleSlotAction(Player entity, int slot, int changeType, int meta, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = MeltingMachineGUIMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (slot == 0 && changeType == 0) {
            MeltingMachineConfigChangeProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (slot == 2 && changeType == 0) {
            MeltingMachineMoldConfigChangeProcedure.execute((LevelAccessor)world, x, y, z);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        Ftm2Mod.addNetworkMessage(MeltingMachineGUISlotMessage.class, MeltingMachineGUISlotMessage::buffer, MeltingMachineGUISlotMessage::new, MeltingMachineGUISlotMessage::handler);
    }
}

