/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrcommunityquest;

import eu.mrneznamy.mrcommunityquest.commands.AdminCommand;
import eu.mrneznamy.mrcommunityquest.commands.CommunityQuestCommand;
import eu.mrneznamy.mrcommunityquest.data.PlayerSettingsManager;
import eu.mrneznamy.mrcommunityquest.data.QuestProgressManager;
import eu.mrneznamy.mrcommunityquest.display.ProgressMessageManager;
import eu.mrneznamy.mrcommunityquest.economy.EconomyManager;
import eu.mrneznamy.mrcommunityquest.gui.GUIListener;
import eu.mrneznamy.mrcommunityquest.gui.QuestGUI;
import eu.mrneznamy.mrcommunityquest.hooks.PlaceholderAPIExpansion;
import eu.mrneznamy.mrcommunityquest.listener.BlockBreakListener;
import eu.mrneznamy.mrcommunityquest.listener.BlockPlaceListener;
import eu.mrneznamy.mrcommunityquest.listener.CraftItemListener;
import eu.mrneznamy.mrcommunityquest.listener.EnchantItemListener;
import eu.mrneznamy.mrcommunityquest.listener.EntityDeathListener;
import eu.mrneznamy.mrcommunityquest.listener.FurnaceExtractListener;
import eu.mrneznamy.mrcommunityquest.listener.MrAuctionsBidListener;
import eu.mrneznamy.mrcommunityquest.listener.MrUltimateFishingListener;
import eu.mrneznamy.mrcommunityquest.listener.MrUltimateJobsListener;
import eu.mrneznamy.mrcommunityquest.listener.MrUltimateShopListener;
import eu.mrneznamy.mrcommunityquest.listener.NuVotifierListener;
import eu.mrneznamy.mrcommunityquest.listener.PlayerFishListener;
import eu.mrneznamy.mrcommunityquest.listener.PlayerPickupItemListener;
import eu.mrneznamy.mrcommunityquest.managers.ConfigManager;
import eu.mrneznamy.mrcommunityquest.managers.MessageManager;
import eu.mrneznamy.mrcommunityquest.quests.CommunityQuestManager;
import eu.mrneznamy.mrcommunityquest.rewards.RewardsManager;
import eu.mrneznamy.mrcommunityquest.scheduler.AutoScheduler;
import eu.mrneznamy.mrcommunityquest.utils.VersionDetector;
import eu.mrneznamy.mrlibcore.MrLibRegisterPlugin;
import eu.mrneznamy.mrlibcore.messages.MrLibMessage;
import eu.mrneznamy.mrlibcore.utils.MrLibColors;
import eu.mrneznamy.mrlibcore.utils.MrLibConsoleSayer;
import eu.mrneznamy.mrlibcore.utils.MrLibHelper;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class MrCommunityQuest
extends JavaPlugin
implements Listener {
    private static MrCommunityQuest instance;
    private ConfigManager configManager;
    private MessageManager messageManager;
    private CommunityQuestManager questManager;
    private QuestGUI questGUI;
    private GUIListener guiListener;
    private BlockBreakListener blockBreakListener;
    private BlockPlaceListener blockPlaceListener;
    private EntityDeathListener entityDeathListener;
    private PlayerPickupItemListener playerPickupItemListener;
    private CraftItemListener craftItemListener;
    private FurnaceExtractListener furnaceExtractListener;
    private PlayerFishListener playerFishListener;
    private EnchantItemListener enchantItemListener;
    private NuVotifierListener nuVotifierListener;
    private MrUltimateShopListener mrUltimateShopListener;
    private MrUltimateFishingListener mrUltimateFishingListener;
    private MrUltimateJobsListener mrUltimateJobsListener;
    private MrAuctionsBidListener mrAuctionsBidListener;
    private RewardsManager rewardsManager;
    private AutoScheduler autoScheduler;
    private PlayerSettingsManager playerSettingsManager;
    private ProgressMessageManager progressMessageManager;
    private EconomyManager economyManager;
    private QuestProgressManager questProgressManager;
    private PlaceholderAPIExpansion placeholderAPIExpansion;
    private FileConfiguration questsConfig;
    private FileConfiguration guiConfig;
    private MrLibMessage messageSystem;
    private String prefix;

    public void onEnable() {
        instance = this;
        if (this.getServer().getPluginManager().getPlugin("MrLibCore") == null) {
            this.getLogger().severe("========================================");
            this.getLogger().severe("MrCommunityQuest requires MrLibCore!");
            this.getLogger().severe("Download: https://modrinth.com/plugin/mrlibcore");
            this.getLogger().severe("========================================");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.messageSystem = new MrLibMessage(this);
        MrLibConsoleSayer.MrSay_Success("MrCommunityQuest is starting up...");
        this.configManager = new ConfigManager(this);
        this.configManager.loadConfig();
        this.messageManager = new MessageManager(this);
        MrLibRegisterPlugin.register(this, "mrcommunityquest");
        this.questsConfig = this.configManager.loadQuestsConfig();
        this.guiConfig = this.configManager.loadGUIConfig();
        this.messageManager.loadMessages();
        this.questProgressManager = new QuestProgressManager(this);
        this.questManager = new CommunityQuestManager(this);
        this.rewardsManager = new RewardsManager(this);
        this.economyManager = new EconomyManager(this);
        this.playerSettingsManager = new PlayerSettingsManager(this);
        this.progressMessageManager = new ProgressMessageManager(this);
        this.questGUI = new QuestGUI(this);
        this.guiListener = new GUIListener(this);
        this.blockBreakListener = new BlockBreakListener(this);
        this.blockPlaceListener = new BlockPlaceListener(this);
        this.entityDeathListener = new EntityDeathListener(this);
        this.playerPickupItemListener = new PlayerPickupItemListener(this);
        this.craftItemListener = new CraftItemListener(this);
        this.furnaceExtractListener = new FurnaceExtractListener(this);
        this.playerFishListener = new PlayerFishListener(this);
        this.enchantItemListener = new EnchantItemListener(this);
        this.nuVotifierListener = new NuVotifierListener(this);
        if (VersionDetector.is1_21OrHigher()) {
            try {
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, () -> {
                    try {
                        this.mrUltimateShopListener = new MrUltimateShopListener(this);
                        this.mrUltimateFishingListener = new MrUltimateFishingListener(this);
                        this.mrUltimateJobsListener = new MrUltimateJobsListener(this);
                        this.mrAuctionsBidListener = new MrAuctionsBidListener(this);
                        Bukkit.getScheduler().runTask((Plugin)this, () -> {
                            if (this.mrUltimateShopListener != null) {
                                Bukkit.getPluginManager().registerEvents((Listener)this.mrUltimateShopListener, (Plugin)this);
                            }
                            if (this.mrUltimateFishingListener != null) {
                                Bukkit.getPluginManager().registerEvents((Listener)this.mrUltimateFishingListener, (Plugin)this);
                            }
                            if (this.mrUltimateJobsListener != null) {
                                Bukkit.getPluginManager().registerEvents((Listener)this.mrUltimateJobsListener, (Plugin)this);
                            }
                            if (this.mrAuctionsBidListener != null) {
                                Bukkit.getPluginManager().registerEvents((Listener)this.mrAuctionsBidListener, (Plugin)this);
                            }
                        });
                        MrLibConsoleSayer.MrSay_Success("Plugin listeners initialized for 1.21+ server");
                    }
                    catch (Exception e) {
                        MrLibConsoleSayer.MrSay_Error("Failed to initialize plugin listeners: " + e.getMessage());
                    }
                });
            }
            catch (Exception e) {
                MrLibConsoleSayer.MrSay_Error("Failed to schedule plugin listeners: " + e.getMessage());
            }
        } else {
            MrLibConsoleSayer.MrSay_Info("Skipping plugin listeners on 1.20 server");
        }
        this.autoScheduler = new AutoScheduler(this);
        this.autoScheduler.startScheduler();
        this.getCommand("mqc").setExecutor((CommandExecutor)new AdminCommand(this));
        this.getCommand("cq").setExecutor((CommandExecutor)new CommunityQuestCommand(this));
        this.getCommand("cquest").setExecutor((CommandExecutor)new CommunityQuestCommand(this));
        Bukkit.getPluginManager().registerEvents((Listener)this.guiListener, (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)this.blockBreakListener, (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)this.blockPlaceListener, (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)this.entityDeathListener, (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)this.playerPickupItemListener, (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)this.craftItemListener, (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)this.furnaceExtractListener, (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)this.playerFishListener, (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)this.enchantItemListener, (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)this.nuVotifierListener, (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            this.placeholderAPIExpansion = new PlaceholderAPIExpansion(this);
            this.placeholderAPIExpansion.register();
        }
        this.registerHelpCommands();
        MrLibConsoleSayer.MrSay_Success("Universal Plugin loaded successfully!");
        MrLibConsoleSayer.MrSay_Info("Server version: " + VersionDetector.getVersion());
        MrLibConsoleSayer.MrSay_Info("Detected version: " + (VersionDetector.is1_21OrHigher() ? "1.21+" : "1.20"));
        MrLibConsoleSayer.MrSay_Info("Supports both 1.20 and 1.21+ with automatic detection!");
        if (VersionDetector.is1_21OrHigher()) {
            MrLibConsoleSayer.MrSay_Info("Plugin integration: MrUltimateShop, MrUltimateFishing, MrUltimateJobs, MrAuctionsBid");
        } else {
            MrLibConsoleSayer.MrSay_Info("Plugin integration: Disabled on 1.20 server for compatibility");
        }
    }

    public void onDisable() {
        if (this.questManager != null) {
            this.questManager.saveAllPlayerData();
        }
        if (this.playerSettingsManager != null) {
            this.playerSettingsManager.saveAllPlayerSettings();
        }
        if (this.autoScheduler != null) {
            this.autoScheduler.stopScheduler();
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (this.questManager != null && this.questManager.getPlaceholderQuestManager() != null) {
            this.questManager.getPlaceholderQuestManager().onPlayerJoin(event.getPlayer());
        }
    }

    public static MrCommunityQuest getInstance() {
        return instance;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public MessageManager getMessageManager() {
        return this.messageManager;
    }

    public CommunityQuestManager getQuestManager() {
        return this.questManager;
    }

    public QuestGUI getQuestGUI() {
        return this.questGUI;
    }

    public AutoScheduler getAutoScheduler() {
        return this.autoScheduler;
    }

    public PlayerSettingsManager getPlayerSettingsManager() {
        return this.playerSettingsManager;
    }

    public ProgressMessageManager getProgressMessageManager() {
        return this.progressMessageManager;
    }

    public EconomyManager getEconomyManager() {
        return this.economyManager;
    }

    public RewardsManager getRewardsManager() {
        return this.rewardsManager;
    }

    public FileConfiguration getQuestsConfig() {
        return this.questsConfig;
    }

    public FileConfiguration getGUIConfig() {
        return this.guiConfig;
    }

    public QuestProgressManager getQuestProgressManager() {
        return this.questProgressManager;
    }

    public PlaceholderAPIExpansion getPlaceholderAPIExpansion() {
        return this.placeholderAPIExpansion;
    }

    public MrUltimateShopListener getMrUltimateShopListener() {
        return this.mrUltimateShopListener;
    }

    public MrUltimateFishingListener getMrUltimateFishingListener() {
        return this.mrUltimateFishingListener;
    }

    public MrUltimateJobsListener getMrUltimateJobsListener() {
        return this.mrUltimateJobsListener;
    }

    public MrAuctionsBidListener getMrAuctionsBidListener() {
        return this.mrAuctionsBidListener;
    }

    public MrLibMessage getMessageSystem() {
        return this.messageSystem;
    }

    public String getPrefix() {
        return this.messageManager != null ? this.messageManager.getPrefix() : "&8[&aMrCommunityQuest&8]";
    }

    private void registerHelpCommands() {
        ArrayList<MrLibHelper.CommandInfo> commands = new ArrayList<MrLibHelper.CommandInfo>();
        commands.add(new MrLibHelper.CommandInfo("/cq", "Open community quest menu", "/cq"));
        commands.add(new MrLibHelper.CommandInfo("/cq donate [questId] <amount>", "Donate money to current or specific quest", "/cq donate 100"));
        commands.add(new MrLibHelper.CommandInfo("/cq donateexp [questId] <amount>", "Donate EXP to current or specific quest", "/cq donateexp 50"));
        commands.add(new MrLibHelper.CommandInfo("/cq donatelevel [questId] <amount>", "Donate LEVELS to current or specific quest", "/cq donatelevel 5"));
        commands.add(new MrLibHelper.CommandInfo("/cq donateitem <hand|all> [questId]", "Donate items from hand or all matching items", "/cq donateitem hand"));
        commands.add(new MrLibHelper.CommandInfo("/mqc reload", "Reload plugin configuration", "/mqc reload"));
        commands.add(new MrLibHelper.CommandInfo("/mqc start <quest-id> [duration]", "Start a quest (duration in seconds, default 1 hour)", "/mqc start 1 3600"));
        commands.add(new MrLibHelper.CommandInfo("/mqc end <quest-id>", "End a quest", "/mqc end 1"));
        MrLibHelper.registerPluginCommands(this, "MrCommunityQuest", commands);
    }

    public void sendMessage(Player player, String message) {
        if (message == null || ((String)message).isEmpty()) {
            return;
        }
        if (((String)message).contains("(!NOPREFIX!)")) {
            message = ((String)message).replace("(!NOPREFIX!)", "");
            this.messageSystem.send(player, (String)message);
        } else {
            String prefix = this.getPrefix();
            message = ((String)message).contains("(!message!)") ? ((String)message).replace("(!message!)", "(!message!)" + prefix + " ") : "(!message!)" + prefix + " " + (String)message;
            this.messageSystem.send(player, (String)message);
        }
    }

    public void sendMessage(CommandSender sender, String message) {
        if (message == null || ((String)message).isEmpty()) {
            return;
        }
        if (sender instanceof Player) {
            this.sendMessage((Player)sender, (String)message);
        } else {
            if (((String)message).contains("(!NOPREFIX!)")) {
                message = ((String)message).replace("(!NOPREFIX!)", "");
            }
            if (((String)message).contains("(!message!)")) {
                message = ((String)message).replace("(!message!)", "");
            }
            if (!((String)message).contains("(!NOPREFIX!)")) {
                String prefix = this.getPrefix();
                message = prefix + " " + (String)message;
            }
            sender.sendMessage(MrLibColors.colorize((String)message));
        }
    }

    public void reloadConfiguration() {
        this.configManager.reloadConfig();
        this.questsConfig = this.configManager.loadQuestsConfig();
        this.guiConfig = this.configManager.loadGUIConfig();
        if (this.messageManager != null) {
            this.messageManager.reloadMessages();
        }
        if (this.autoScheduler != null) {
            this.autoScheduler.reload();
        }
        if (this.questManager != null) {
            // empty if block
        }
    }
}

