/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrcommunityquest.commands;

import eu.mrneznamy.mrcommunityquest.MrCommunityQuest;
import eu.mrneznamy.mrlibcore.utils.MrLibHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class CommunityQuestCommand
implements CommandExecutor,
TabCompleter {
    private final MrCommunityQuest plugin;

    public CommunityQuestCommand(MrCommunityQuest plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            if (sender instanceof Player) {
                this.plugin.getQuestGUI().openQuestMenu((Player)sender);
                return true;
            }
            this.plugin.sendMessage(sender, this.plugin.getMessageManager().getMessage("errors.player-only-command", "&cThis command can only be executed by players."));
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "help": {
                if (sender instanceof Player) {
                    MrLibHelper.showPluginHelp((Player)sender, "MrCommunityQuest", 1);
                } else {
                    this.plugin.sendMessage(sender, this.plugin.getMessageManager().getMessage("general.player-only-command"));
                }
                return true;
            }
            case "donate": {
                if (!(sender instanceof Player)) {
                    this.plugin.sendMessage(sender, this.plugin.getMessageManager().getMessage("errors.player-only-command", "&cThis command can only be executed by players."));
                    return true;
                }
                if (args.length < 2) {
                    this.plugin.sendMessage(sender, this.plugin.getMessageManager().getMessage("general.invalid-command"));
                    return true;
                }
                if (args.length == 2) {
                    this.handleDonateCommand((Player)sender, args[1], null);
                } else {
                    this.handleDonateCommand((Player)sender, args[2], args[1]);
                }
                return true;
            }
            case "donateexp": {
                if (!(sender instanceof Player)) {
                    this.plugin.sendMessage(sender, this.plugin.getMessageManager().getMessage("errors.player-only-command", "&cThis command can only be executed by players."));
                    return true;
                }
                if (args.length < 2) {
                    this.plugin.sendMessage(sender, this.plugin.getMessageManager().getMessage("general.invalid-command"));
                    return true;
                }
                if (args.length == 2) {
                    this.handleDonateExpCommand((Player)sender, args[1], null);
                } else {
                    this.handleDonateExpCommand((Player)sender, args[2], args[1]);
                }
                return true;
            }
            case "donatelevel": {
                if (!(sender instanceof Player)) {
                    this.plugin.sendMessage(sender, this.plugin.getMessageManager().getMessage("errors.player-only-command", "&cThis command can only be executed by players."));
                    return true;
                }
                if (args.length < 2) {
                    this.plugin.sendMessage(sender, this.plugin.getMessageManager().getMessage("general.invalid-command"));
                    return true;
                }
                if (args.length == 2) {
                    this.handleDonateLevelCommand((Player)sender, args[1], null);
                } else {
                    this.handleDonateLevelCommand((Player)sender, args[2], args[1]);
                }
                return true;
            }
            case "donateitem": {
                if (!(sender instanceof Player)) {
                    this.plugin.sendMessage(sender, this.plugin.getMessageManager().getMessage("errors.player-only-command", "&cThis command can only be executed by players."));
                    return true;
                }
                if (args.length < 2) {
                    this.plugin.sendMessage(sender, this.plugin.getMessageManager().getMessage("general.invalid-command"));
                    return true;
                }
                String mode = args[1].toLowerCase();
                if (!mode.equals("hand") && !mode.equals("all")) {
                    this.plugin.sendMessage(sender, this.plugin.getMessageManager().getMessage("general.invalid-command"));
                    return true;
                }
                boolean allItems = mode.equals("all");
                String questIdForItem = args.length >= 3 ? args[2] : null;
                this.handleDonateItemCommand((Player)sender, allItems, questIdForItem);
                return true;
            }
        }
        this.plugin.sendMessage(sender, this.plugin.getMessageManager().getMessage("general.invalid-command"));
        return true;
    }

    private void handleDonateCommand(Player player, String amountStr, String questId) {
        double amount;
        if (!this.plugin.getQuestManager().isDonateQuestActive()) {
            this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("quests.donate-quest-not-active"));
            return;
        }
        try {
            amount = Double.parseDouble(amountStr);
        }
        catch (NumberFormatException e) {
            this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("general.invalid-command"));
            return;
        }
        this.plugin.getQuestManager().processDonation(player, amount, questId);
        this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("quests.donate-success").replace("[amount]", String.valueOf(amount)));
    }

    private void handleDonateExpCommand(Player player, String amountStr, String questId) {
        int amount;
        if (!this.plugin.getQuestManager().isExpDonateQuestActive()) {
            this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("quests.donate-quest-not-active"));
            return;
        }
        try {
            amount = Integer.parseInt(amountStr);
        }
        catch (NumberFormatException e) {
            this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("general.invalid-command"));
            return;
        }
        this.plugin.getQuestManager().processExpDonation(player, amount, questId);
        this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("quests.donate-exp-success").replace("[amount]", String.valueOf(amount)));
    }

    private void handleDonateLevelCommand(Player player, String amountStr, String questId) {
        int amount;
        if (!this.plugin.getQuestManager().isLevelDonateQuestActive()) {
            this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("quests.donate-quest-not-active"));
            return;
        }
        try {
            amount = Integer.parseInt(amountStr);
        }
        catch (NumberFormatException e) {
            this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("general.invalid-command"));
            return;
        }
        this.plugin.getQuestManager().processLevelDonation(player, amount, questId);
        this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("quests.donate-level-success").replace("[amount]", String.valueOf(amount)));
    }

    private void handleDonateItemCommand(Player player, boolean allItems, String questId) {
        if (!this.plugin.getQuestManager().isItemDonateQuestActive()) {
            this.plugin.sendMessage(player, this.plugin.getMessageManager().getMessage("quests.donate-quest-not-active"));
            return;
        }
        this.plugin.getQuestManager().processItemDonation(player, allItems, questId);
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            List<String> completions = Arrays.asList("help", "donate", "donateexp", "donatelevel", "donateitem");
            return this.filterCompletions(completions, args[0]);
        }
        if (args.length == 2) {
            if (args[0].equalsIgnoreCase("donate") || args[0].equalsIgnoreCase("donateexp") || args[0].equalsIgnoreCase("donatelevel")) {
                Map<String, Long> activeQuests = this.plugin.getQuestGUI().getActiveQuests();
                if (activeQuests.isEmpty()) {
                    return Collections.emptyList();
                }
                ArrayList<String> questIds = new ArrayList<String>(activeQuests.keySet());
                return this.filterCompletions(questIds, args[1]);
            }
            if (args[0].equalsIgnoreCase("donateitem")) {
                List<String> modes = Arrays.asList("hand", "all");
                return this.filterCompletions(modes, args[1]);
            }
        }
        if (args.length == 3 && args[0].equalsIgnoreCase("donateitem")) {
            Map<String, Long> activeQuests = this.plugin.getQuestGUI().getActiveQuests();
            if (activeQuests.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<String> questIds = new ArrayList<String>(activeQuests.keySet());
            return this.filterCompletions(questIds, args[2]);
        }
        return Collections.emptyList();
    }

    private List<String> filterCompletions(List<String> completions, String arg) {
        ArrayList<String> result = new ArrayList<String>();
        for (String completion : completions) {
            if (!completion.toLowerCase().startsWith(arg.toLowerCase())) continue;
            result.add(completion);
        }
        return result;
    }
}

