/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrcommunityquest.listener;

import eu.mrneznamy.mrcommunityquest.MrCommunityQuest;
import eu.mrneznamy.mrcommunityquest.quests.CommunityQuestManager;
import java.util.List;
import java.util.UUID;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;

public class EntityDeathListener
implements Listener {
    private final MrCommunityQuest plugin;
    private final CommunityQuestManager questManager;

    public EntityDeathListener(MrCommunityQuest plugin) {
        this.plugin = plugin;
        this.questManager = plugin.getQuestManager();
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onEntityDeath(EntityDeathEvent event) {
        if (event.getEntity().getKiller() == null) {
            return;
        }
        Player player = event.getEntity().getKiller();
        UUID playerId = player.getUniqueId();
        if (this.isWorldDisabled(event.getEntity().getWorld().getName())) {
            return;
        }
        String entityType = event.getEntityType().name();
        this.questManager.updateKillEntityQuestProgress(playerId, entityType);
        if (event.getEntity() instanceof Player) {
            Player killedPlayer = (Player)event.getEntity();
            this.questManager.updateKillPlayerQuestProgress(playerId);
        }
    }

    private boolean isWorldDisabled(String worldName) {
        FileConfiguration config = this.plugin.getConfig();
        if (config == null) {
            return false;
        }
        List disabledWorlds = config.getStringList("MrCommunityQuest.Settings.Disabled-Worlds");
        return disabledWorlds.contains(worldName);
    }
}

