/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrcommunityquest.listener;

import eu.mrneznamy.mrcommunityquest.MrCommunityQuest;
import eu.mrneznamy.mrcommunityquest.quests.CommunityQuestManager;
import java.util.List;
import java.util.UUID;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerFishEvent;

public class PlayerFishListener
implements Listener {
    private final MrCommunityQuest plugin;
    private final CommunityQuestManager questManager;

    public PlayerFishListener(MrCommunityQuest plugin) {
        this.plugin = plugin;
        this.questManager = plugin.getQuestManager();
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerFish(PlayerFishEvent event) {
        if (event.getState() != PlayerFishEvent.State.CAUGHT_FISH) {
            return;
        }
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        if (this.isWorldDisabled(player.getWorld().getName())) {
            return;
        }
        String entityType = "FISH";
        if (event.getCaught() != null) {
            entityType = event.getCaught().getType().name();
        }
        this.questManager.updateCatchQuestProgress(playerId, entityType);
    }

    private boolean isWorldDisabled(String worldName) {
        FileConfiguration config = this.plugin.getConfig();
        if (config == null) {
            return false;
        }
        List disabledWorlds = config.getStringList("MrCommunityQuest.Settings.Disabled-Worlds");
        return disabledWorlds.contains(worldName);
    }
}

