/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrcommunityquest.managers;

import eu.mrneznamy.mrcommunityquest.MrCommunityQuest;
import java.io.File;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigManager {
    private final MrCommunityQuest plugin;
    private FileConfiguration config;
    private FileConfiguration questsConfig;
    private FileConfiguration guiConfig;

    public ConfigManager(MrCommunityQuest plugin) {
        this.plugin = plugin;
    }

    public void loadConfig() {
        File configFile = new File(this.plugin.getDataFolder(), "config.yml");
        if (configFile.exists()) {
            this.plugin.reloadConfig();
            this.config = this.plugin.getConfig();
        } else {
            this.config = new YamlConfiguration();
        }
    }

    public void reloadConfig() {
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
    }

    public FileConfiguration loadQuestsConfig() {
        File questsFile = new File(this.plugin.getDataFolder(), "quests.yml");
        this.questsConfig = questsFile.exists() ? YamlConfiguration.loadConfiguration((File)questsFile) : new YamlConfiguration();
        return this.questsConfig;
    }

    public FileConfiguration loadGUIConfig() {
        File guiFile = new File(this.plugin.getDataFolder(), "gui.yml");
        this.guiConfig = guiFile.exists() ? YamlConfiguration.loadConfiguration((File)guiFile) : new YamlConfiguration();
        return this.guiConfig;
    }

    public String getPrefix() {
        return this.config.getString("MrCommunityQuest.Prefix", "{#8C8C8C>}&lMrCommunityQuest{#B5B5B5<} &8| ");
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public FileConfiguration getQuestsConfig() {
        return this.questsConfig;
    }

    public FileConfiguration getGUIConfig() {
        return this.guiConfig;
    }
}

