/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrcommunityquest.managers;

import eu.mrneznamy.mrcommunityquest.MrCommunityQuest;
import eu.mrneznamy.mrlibcore.utils.MrLibColors;
import java.io.File;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class MessageManager {
    private final MrCommunityQuest plugin;
    private FileConfiguration messagesConfig;
    private File messagesFile;

    public MessageManager(MrCommunityQuest plugin) {
        this.plugin = plugin;
    }

    public void loadMessages() {
        this.messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
        this.messagesConfig = this.messagesFile.exists() ? YamlConfiguration.loadConfiguration((File)this.messagesFile) : new YamlConfiguration();
    }

    public void reloadMessages() {
        if (this.messagesFile == null) {
            this.messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
        }
        this.messagesConfig = this.messagesFile.exists() ? YamlConfiguration.loadConfiguration((File)this.messagesFile) : new YamlConfiguration();
    }

    public String getMessage(String path) {
        String message = this.messagesConfig.getString("MrCommunityQuest." + path);
        if (message == null) {
            message = this.messagesConfig.getString(path);
        }
        if (message == null) {
            return MrLibColors.colorize("&cMessage not found: " + path);
        }
        return message;
    }

    public String getMessage(String path, String defaultMessage) {
        String message = this.messagesConfig.getString("MrCommunityQuest." + path);
        if (message == null) {
            message = this.messagesConfig.getString(path, defaultMessage);
        }
        return message;
    }

    public String getPrefix() {
        String prefix = this.messagesConfig.getString("MrCommunityQuest.Prefix", "{#8C8C8C>}&lMrCommunityQuest{#B5B5B5<} &8| ");
        return MrLibColors.colorize(prefix);
    }

    public FileConfiguration getMessagesConfig() {
        return this.messagesConfig;
    }
}

