/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrcommunityquest.quests;

import eu.mrneznamy.mrcommunityquest.MrCommunityQuest;
import eu.mrneznamy.mrcommunityquest.quests.CommunityQuestManager;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class PlaceholderQuestManager {
    private final MrCommunityQuest plugin;
    private final Map<String, Map<UUID, Double>> initialPlaceholderValues;
    private final Map<String, Map<UUID, Double>> currentPlaceholderValues;
    private BukkitTask updateTask;
    private File placeholderDataFile;

    public PlaceholderQuestManager(MrCommunityQuest plugin) {
        this.plugin = plugin;
        this.initialPlaceholderValues = new HashMap<String, Map<UUID, Double>>();
        this.currentPlaceholderValues = new HashMap<String, Map<UUID, Double>>();
        this.placeholderDataFile = new File(plugin.getDataFolder(), "placeholder_data.yml");
        this.loadPlaceholderData();
    }

    public void startPlaceholderUpdateTask() {
        if (this.updateTask != null) {
            this.updateTask.cancel();
        }
        this.updateTask = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, this::updatePlaceholderValues, 100L, 100L);
    }

    public void stopPlaceholderUpdateTask() {
        if (this.updateTask != null) {
            this.updateTask.cancel();
            this.updateTask = null;
        }
    }

    public void initializeQuest(String questId) {
        FileConfiguration questsConfig = this.plugin.getQuestsConfig();
        if (questsConfig == null) {
            return;
        }
        ConfigurationSection questSection = questsConfig.getConfigurationSection("MrCommunityQuest.Quests." + questId + ".Quest");
        if (questSection == null) {
            return;
        }
        String provider = questSection.getString("Provider", "VANILLA");
        if (!"PLACEHOLDERAPI".equalsIgnoreCase(provider)) {
            return;
        }
        String placeholder = questSection.getString("Placeholder", "");
        if (placeholder.isEmpty()) {
            return;
        }
        this.initialPlaceholderValues.putIfAbsent(questId, new HashMap());
        this.currentPlaceholderValues.putIfAbsent(questId, new HashMap());
        for (Player player : Bukkit.getServer().getOnlinePlayers()) {
            if (!this.canPlayerParticipateInQuest(player, questId)) continue;
            this.initializePlayerPlaceholderValue(questId, player, placeholder);
        }
    }

    public void initializePlayerPlaceholderValue(String questId, Player player, String placeholder) {
        String valueStr = PlaceholderAPI.setPlaceholders((Player)player, (String)placeholder);
        double value = this.parsePlaceholderValue(valueStr);
        this.initialPlaceholderValues.computeIfAbsent(questId, k -> new HashMap()).put(player.getUniqueId(), value);
        this.currentPlaceholderValues.computeIfAbsent(questId, k -> new HashMap()).put(player.getUniqueId(), value);
    }

    private boolean canPlayerParticipateInQuest(Player player, String questId) {
        FileConfiguration questsConfig = this.plugin.getQuestsConfig();
        if (questsConfig == null) {
            return true;
        }
        ConfigurationSection questSection = questsConfig.getConfigurationSection("MrCommunityQuest.Quests." + questId + ".Quest");
        if (questSection == null) {
            return true;
        }
        String permission = questSection.getString("Permission", "");
        if (!permission.isEmpty()) {
            return player.hasPermission(permission);
        }
        return true;
    }

    private double parsePlaceholderValue(String valueStr) {
        if (valueStr == null || valueStr.isEmpty()) {
            return 0.0;
        }
        if (valueStr.equalsIgnoreCase("invalid") || valueStr.equalsIgnoreCase("null") || valueStr.equalsIgnoreCase("undefined") || valueStr.equalsIgnoreCase("none")) {
            return 0.0;
        }
        try {
            return Double.parseDouble(valueStr);
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    private void updatePlaceholderValues() {
        FileConfiguration questsConfig = this.plugin.getQuestsConfig();
        if (questsConfig == null) {
            return;
        }
        ConfigurationSection questsSection = questsConfig.getConfigurationSection("MrCommunityQuest.Quests");
        if (questsSection == null) {
            return;
        }
        for (String questKey : questsSection.getKeys(false)) {
            String placeholder;
            String provider;
            ConfigurationSection questSection = questsSection.getConfigurationSection(questKey + ".Quest");
            if (questSection == null || !"PLACEHOLDERAPI".equalsIgnoreCase(provider = questSection.getString("Provider", "VANILLA")) || !this.plugin.getQuestGUI().isQuestActive(questKey) || (placeholder = questSection.getString("Placeholder", "")).isEmpty()) continue;
            boolean trackDecreases = questSection.getBoolean("TrackDecreases", false);
            for (Player player : Bukkit.getServer().getOnlinePlayers()) {
                if (!this.canPlayerParticipateInQuest(player, questKey)) continue;
                UUID playerId = player.getUniqueId();
                String valueStr = PlaceholderAPI.setPlaceholders((Player)player, (String)placeholder);
                double currentValue = this.parsePlaceholderValue(valueStr);
                this.currentPlaceholderValues.computeIfAbsent(questKey, k -> new HashMap()).put(playerId, currentValue);
                Map<UUID, Double> questInitialValues = this.initialPlaceholderValues.get(questKey);
                if (questInitialValues == null) continue;
                Double initialValue = questInitialValues.get(playerId);
                if (initialValue == null) {
                    this.initializePlayerPlaceholderValue(questKey, player, placeholder);
                    initialValue = currentValue;
                }
                int progress = trackDecreases ? (int)Math.max(0.0, initialValue - currentValue) : (int)Math.max(0.0, currentValue - initialValue);
                CommunityQuestManager questManager = this.plugin.getQuestManager();
                if (questManager == null) continue;
                questManager.getQuestTracker().updateProgress(questKey, playerId, progress);
                if (!questManager.getQuestTracker().isQuestCompleted(questKey)) continue;
                questManager.getRewardsManager().distributeRewards(questKey);
                questManager.getQuestTracker().saveQuestProgress();
                questManager.getQuestTracker().resetQuestProgress(questKey);
                if (this.plugin.getProgressMessageManager() != null) {
                    this.plugin.getProgressMessageManager().resetQuestThresholds(questKey);
                }
                if (this.plugin.getQuestGUI() != null) {
                    this.plugin.getQuestGUI().endQuest(questKey);
                }
                String questName = questSection.getString("QuestName", "Quest " + questKey);
                if (this.plugin.getServer() == null || this.plugin.getMessageManager() == null) continue;
                this.plugin.getServer().broadcastMessage(this.plugin.getMessageManager().getMessage("quests.quest-completed-broadcast").replace("[quest]", questName));
            }
        }
    }

    public void cleanupQuest(String questId) {
        this.initialPlaceholderValues.remove(questId);
        this.currentPlaceholderValues.remove(questId);
        this.savePlaceholderData();
    }

    public void savePlaceholderData() {
    }

    public void loadPlaceholderData() {
    }

    public void onPlayerJoin(Player player) {
        FileConfiguration questsConfig = this.plugin.getQuestsConfig();
        if (questsConfig == null) {
            return;
        }
        ConfigurationSection questsSection = questsConfig.getConfigurationSection("MrCommunityQuest.Quests");
        if (questsSection == null) {
            return;
        }
        for (String questKey : questsSection.getKeys(false)) {
            String placeholder;
            String provider;
            ConfigurationSection questSection = questsSection.getConfigurationSection(questKey + ".Quest");
            if (questSection == null || !"PLACEHOLDERAPI".equalsIgnoreCase(provider = questSection.getString("Provider", "VANILLA")) || !this.plugin.getQuestGUI().isQuestActive(questKey) || !this.canPlayerParticipateInQuest(player, questKey) || (placeholder = questSection.getString("Placeholder", "")).isEmpty()) continue;
            String valueStr = PlaceholderAPI.setPlaceholders((Player)player, (String)placeholder);
            double value = this.parsePlaceholderValue(valueStr);
            this.initialPlaceholderValues.computeIfAbsent(questKey, k -> new HashMap()).put(player.getUniqueId(), value);
            this.currentPlaceholderValues.computeIfAbsent(questKey, k -> new HashMap()).put(player.getUniqueId(), value);
        }
    }
}

