/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrcommunityquest.quests;

import eu.mrneznamy.mrcommunityquest.MrCommunityQuest;
import eu.mrneznamy.mrcommunityquest.data.DataManager;
import eu.mrneznamy.mrcommunityquest.quests.PlayerQuestData;
import eu.mrneznamy.mrcommunityquest.quests.Quest;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class QuestManager {
    private final MrCommunityQuest plugin;
    private final Map<String, Quest> quests;
    private final DataManager dataManager;
    private final Map<UUID, PlayerQuestData> playerQuestDataCache;
    private File questsFolder;
    private File questDataFolder;

    public QuestManager(MrCommunityQuest plugin) {
        this.plugin = plugin;
        this.quests = new HashMap<String, Quest>();
        this.dataManager = new DataManager(plugin);
        this.playerQuestDataCache = new HashMap<UUID, PlayerQuestData>();
        this.questsFolder = new File(plugin.getDataFolder(), "quests");
        this.questDataFolder = new File(plugin.getDataFolder(), "questdata");
        if (!this.questsFolder.exists()) {
            this.questsFolder.mkdirs();
        }
        if (!this.questDataFolder.exists()) {
            this.questDataFolder.mkdirs();
        }
        this.loadQuests();
    }

    public void loadQuests() {
        this.quests.clear();
        if (!this.questsFolder.exists() || !this.questsFolder.isDirectory()) {
            return;
        }
        File[] questFiles = this.questsFolder.listFiles((dir, name) -> name.toLowerCase().endsWith(".yml"));
        if (questFiles == null) {
            return;
        }
        for (File questFile : questFiles) {
            try {
                YamlConfiguration config = YamlConfiguration.loadConfiguration((File)questFile);
                String questId = questFile.getName().replace(".yml", "");
                Quest quest = new Quest(questId, (FileConfiguration)config);
                this.quests.put(questId, quest);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void saveQuests() {
        for (Quest quest : this.quests.values()) {
            try {
                File questFile = new File(this.questsFolder, quest.getId() + ".yml");
                quest.getConfig().save(questFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public Quest getQuest(String id) {
        return this.quests.get(id);
    }

    public Map<String, Quest> getQuests() {
        return new HashMap<String, Quest>(this.quests);
    }

    public PlayerQuestData getPlayerQuestData(UUID playerId) {
        if (this.playerQuestDataCache.containsKey(playerId)) {
            return this.playerQuestDataCache.get(playerId);
        }
        PlayerQuestData data = this.loadPlayerQuestData(playerId);
        this.playerQuestDataCache.put(playerId, data);
        return data;
    }

    private PlayerQuestData loadPlayerQuestData(UUID playerId) {
        File dataFile = new File(this.questDataFolder, playerId.toString() + ".yml");
        if (!dataFile.exists()) {
            return new PlayerQuestData(playerId);
        }
        try {
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)dataFile);
            PlayerQuestData data = new PlayerQuestData(playerId);
            config.getStringList("completed-quests").forEach(data::addCompletedQuest);
            config.getStringList("active-quests").forEach(data::addActiveQuest);
            return data;
        }
        catch (Exception e) {
            return new PlayerQuestData(playerId);
        }
    }

    public void savePlayerQuestData(UUID playerId) {
        PlayerQuestData data = this.playerQuestDataCache.get(playerId);
        if (data == null) {
            return;
        }
        File dataFile = new File(this.questDataFolder, playerId.toString() + ".yml");
        try {
            YamlConfiguration config = new YamlConfiguration();
            config.set("completed-quests", data.getCompletedQuests());
            config.set("active-quests", data.getActiveQuests());
            config.save(dataFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean startQuest(Player player, String questId) {
        Quest quest = this.getQuest(questId);
        if (quest == null) {
            player.sendMessage(this.plugin.getMessageManager().getMessage("quests.quest-not-found"));
            return false;
        }
        PlayerQuestData data = this.getPlayerQuestData(player.getUniqueId());
        if (data.hasCompletedQuest(questId)) {
            player.sendMessage(this.plugin.getMessageManager().getMessage("quests.quest-already-completed"));
            return false;
        }
        if (data.hasActiveQuest(questId)) {
            player.sendMessage(this.plugin.getMessageManager().getMessage("quests.quest-in-progress"));
            return false;
        }
        data.addActiveQuest(questId);
        this.savePlayerQuestData(player.getUniqueId());
        player.sendMessage(this.plugin.getMessageManager().getMessage("quests.quest-started").replace("[quest]", quest.getName()));
        return true;
    }

    public boolean completeQuest(Player player, String questId) {
        Quest quest = this.getQuest(questId);
        if (quest == null) {
            player.sendMessage(this.plugin.getMessageManager().getMessage("quests.quest-not-found"));
            return false;
        }
        PlayerQuestData data = this.getPlayerQuestData(player.getUniqueId());
        if (!data.hasActiveQuest(questId)) {
            player.sendMessage(this.plugin.getMessageManager().getMessage("quests.quest-not-active"));
            return false;
        }
        data.removeActiveQuest(questId);
        data.addCompletedQuest(questId);
        this.savePlayerQuestData(player.getUniqueId());
        player.sendMessage(this.plugin.getMessageManager().getMessage("quests.quest-completed").replace("[quest]", quest.getName()).replace("[reward]", "reward"));
        return true;
    }

    public void saveAllPlayerQuestData() {
        for (UUID playerId : this.playerQuestDataCache.keySet()) {
            this.savePlayerQuestData(playerId);
        }
    }

    public DataManager getDataManager() {
        return this.dataManager;
    }
}

