/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrcommunityquest.rewards;

import eu.mrneznamy.mrcommunityquest.MrCommunityQuest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class RewardsManager {
    private final MrCommunityQuest plugin;

    public RewardsManager(MrCommunityQuest plugin) {
        this.plugin = plugin;
    }

    public void distributeRewards(String questId) {
        ConfigurationSection questSection = this.plugin.getQuestsConfig().getConfigurationSection("MrCommunityQuest.Quests." + questId + ".Quest");
        if (questSection == null) {
            return;
        }
        ConfigurationSection rewardSection = questSection.getConfigurationSection("RewardSystem");
        if (rewardSection == null) {
            return;
        }
        Map<UUID, Integer> contributions = this.plugin.getQuestManager().getQuestTracker().getQuestProgress(questId);
        TreeMap<Integer, List> sortedContributions = new TreeMap<Integer, List>((a, b) -> b.compareTo((Integer)a));
        for (Map.Entry<UUID, Integer> entry : contributions.entrySet()) {
            sortedContributions.computeIfAbsent(entry.getValue(), k -> new ArrayList()).add(entry.getKey());
        }
        ConfigurationSection positionRewards = rewardSection.getConfigurationSection("Position-Rewards");
        if (positionRewards != null) {
            int position = 1;
            for (Map.Entry entry : sortedContributions.entrySet()) {
                List players = (List)entry.getValue();
                for (UUID playerId : players) {
                    Player player = Bukkit.getServer().getPlayer(playerId);
                    if (player == null || !player.isOnline()) continue;
                    this.givePositionReward(player, positionRewards, position, player.getName());
                }
                ++position;
            }
        }
        List participationRewards = rewardSection.getStringList("Participation-Rewards");
        for (UUID uUID : contributions.keySet()) {
            Player player = Bukkit.getServer().getPlayer(uUID);
            if (player == null || !player.isOnline()) continue;
            this.giveParticipationRewards(player, participationRewards, player.getName());
        }
    }

    private void givePositionReward(Player player, ConfigurationSection positionRewards, int position, String playerName) {
        for (String rewardKey : positionRewards.getKeys(false)) {
            int rewardPosition;
            ConfigurationSection rewardSection = positionRewards.getConfigurationSection(rewardKey);
            if (rewardSection == null || (rewardPosition = rewardSection.getInt("Position", -1)) != position) continue;
            List rewards = rewardSection.getStringList("Rewards");
            this.executeRewards(player, rewards, playerName);
            break;
        }
    }

    private void giveParticipationRewards(Player player, List<String> rewards, String playerName) {
        this.executeRewards(player, rewards, playerName);
    }

    private void executeRewards(Player player, List<String> rewards, String playerName) {
        for (String reward : rewards) {
            String command = reward.replace("[PlayerName]", playerName);
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command);
        }
    }
}

