/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrcommunityquest.utils;

import org.bukkit.Bukkit;

public class VersionDetector {
    private static final String VERSION = Bukkit.getVersion();
    private static final boolean IS_1_21_OR_HIGHER = VersionDetector.isVersion1_21OrHigher();

    public static boolean is1_21OrHigher() {
        return IS_1_21_OR_HIGHER;
    }

    public static boolean is1_20() {
        return !IS_1_21_OR_HIGHER;
    }

    public static String getVersion() {
        return VERSION;
    }

    public static boolean isBlockAvailable(String blockType) {
        if (IS_1_21_OR_HIGHER) {
            return true;
        }
        return !VersionDetector.is1_21SpecificBlock(blockType);
    }

    private static boolean is1_21SpecificBlock(String blockType) {
        String[] blocks1_21;
        for (String block : blocks1_21 = new String[]{"COPPER_BULB", "COPPER_DOOR", "COPPER_GRATE", "COPPER_TRAPDOOR", "EXPOSED_COPPER_BULB", "EXPOSED_COPPER_DOOR", "EXPOSED_COPPER_GRATE", "EXPOSED_COPPER_TRAPDOOR", "WEATHERED_COPPER_BULB", "WEATHERED_COPPER_DOOR", "WEATHERED_COPPER_GRATE", "WEATHERED_COPPER_TRAPDOOR", "OXIDIZED_COPPER_BULB", "OXIDIZED_COPPER_DOOR", "OXIDIZED_COPPER_GRATE", "OXIDIZED_COPPER_TRAPDOOR", "WAXED_COPPER_BULB", "WAXED_COPPER_DOOR", "WAXED_COPPER_GRATE", "WAXED_COPPER_TRAPDOOR", "WAXED_EXPOSED_COPPER_BULB", "WAXED_EXPOSED_COPPER_DOOR", "WAXED_EXPOSED_COPPER_GRATE", "WAXED_EXPOSED_COPPER_TRAPDOOR", "WAXED_WEATHERED_COPPER_BULB", "WAXED_WEATHERED_COPPER_DOOR", "WAXED_WEATHERED_COPPER_GRATE", "WAXED_WEATHERED_COPPER_TRAPDOOR", "WAXED_OXIDIZED_COPPER_BULB", "WAXED_OXIDIZED_COPPER_DOOR", "WAXED_OXIDIZED_COPPER_GRATE", "WAXED_OXIDIZED_COPPER_TRAPDOOR", "TRIAL_SPAWNER", "VAULT", "TRIAL_KEY", "OMINOUS_TRIAL_KEY", "BREEZE_ROD", "MACE", "WIND_CHARGE", "FLOW_ARMOR_TRIM_SMITHING_TEMPLATE", "BOLT_ARMOR_TRIM_SMITHING_TEMPLATE", "COAST_ARMOR_TRIM_SMITHING_TEMPLATE", "DUNE_ARMOR_TRIM_SMITHING_TEMPLATE", "EYE_ARMOR_TRIM_SMITHING_TEMPLATE", "HOST_ARMOR_TRIM_SMITHING_TEMPLATE", "RAISER_ARMOR_TRIM_SMITHING_TEMPLATE", "RIB_ARMOR_TRIM_SMITHING_TEMPLATE", "SENTRY_ARMOR_TRIM_SMITHING_TEMPLATE", "SHAPER_ARMOR_TRIM_SMITHING_TEMPLATE", "SILENCE_ARMOR_TRIM_SMITHING_TEMPLATE", "SNAUT_ARMOR_TRIM_SMITHING_TEMPLATE", "SPIRE_ARMOR_TRIM_SMITHING_TEMPLATE", "TIDE_ARMOR_TRIM_SMITHING_TEMPLATE", "VEX_ARMOR_TRIM_SMITHING_TEMPLATE", "WARD_ARMOR_TRIM_SMITHING_TEMPLATE", "WAYFINDER_ARMOR_TRIM_SMITHING_TEMPLATE", "WILD_ARMOR_TRIM_SMITHING_TEMPLATE", "HEAVY_CORE", "BREEZE_SPAWN_EGG", "BOGGED_SPAWN_EGG"}) {
            if (!block.equalsIgnoreCase(blockType)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEntityAvailable(String entityType) {
        if (IS_1_21_OR_HIGHER) {
            return true;
        }
        return !VersionDetector.is1_21SpecificEntity(entityType);
    }

    private static boolean is1_21SpecificEntity(String entityType) {
        String[] entities1_21;
        for (String entity : entities1_21 = new String[]{"BREEZE", "BOGGED"}) {
            if (!entity.equalsIgnoreCase(entityType)) continue;
            return true;
        }
        return false;
    }

    private static boolean isVersion1_21OrHigher() {
        try {
            String version = VERSION.toLowerCase();
            if (version.contains("1.21")) {
                return true;
            }
            return version.contains("1.22") || version.contains("1.23") || version.contains("1.24") || version.contains("1.25") || version.contains("2.");
        }
        catch (Exception e) {
            return false;
        }
    }
}

