/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrlibcore;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;

public class MrLibVersionDetector {
    private static final Pattern VERSION_PATTERN = Pattern.compile("\\(MC: (\\d+)\\.(\\d+)(?:\\.(\\d+))?\\)");
    private static String cachedVersion = null;
    private static int[] cachedVersionParts = null;

    public static String getFullVersion() {
        return Bukkit.getVersion();
    }

    public static String getVersion() {
        if (cachedVersion != null) {
            return cachedVersion;
        }
        String version = Bukkit.getVersion();
        Matcher matcher = VERSION_PATTERN.matcher(version);
        if (matcher.find()) {
            String major = matcher.group(1);
            String minor = matcher.group(2);
            String patch = matcher.group(3);
            cachedVersion = major + "." + minor + (String)(patch != null ? "." + patch : "");
            return cachedVersion;
        }
        return "Unknown";
    }

    public static int getMajorVersion() {
        MrLibVersionDetector.parseVersion();
        return cachedVersionParts != null ? cachedVersionParts[1] : 0;
    }

    public static int getMinorVersion() {
        MrLibVersionDetector.parseVersion();
        return cachedVersionParts != null && cachedVersionParts.length > 2 ? cachedVersionParts[2] : 0;
    }

    public static boolean isAtLeast(int major) {
        return MrLibVersionDetector.getMajorVersion() >= major;
    }

    public static boolean isAtLeast(int major, int minor) {
        int serverMajor = MrLibVersionDetector.getMajorVersion();
        int serverMinor = MrLibVersionDetector.getMinorVersion();
        if (serverMajor > major) {
            return true;
        }
        if (serverMajor < major) {
            return false;
        }
        return serverMinor >= minor;
    }

    public static boolean isInRange(int minMajor, int maxMajor) {
        int version = MrLibVersionDetector.getMajorVersion();
        return version >= minMajor && version <= maxMajor;
    }

    public static boolean is1_19() {
        return MrLibVersionDetector.getMajorVersion() == 19;
    }

    public static boolean is1_20() {
        return MrLibVersionDetector.getMajorVersion() == 20;
    }

    public static boolean is1_21() {
        return MrLibVersionDetector.getMajorVersion() == 21;
    }

    public static boolean isSupported() {
        int version = MrLibVersionDetector.getMajorVersion();
        int minor = MrLibVersionDetector.getMinorVersion();
        if (version < 19) {
            return false;
        }
        if (version > 21) {
            return false;
        }
        return version != 21 || minor <= 9;
    }

    public static int getVersionNumber() {
        MrLibVersionDetector.parseVersion();
        if (cachedVersionParts == null) {
            return 0;
        }
        int major = cachedVersionParts[0];
        int minor = cachedVersionParts[1];
        int patch = cachedVersionParts.length > 2 ? cachedVersionParts[2] : 0;
        return major * 100000 + minor * 1000 + patch;
    }

    private static void parseVersion() {
        if (cachedVersionParts != null) {
            return;
        }
        String version = Bukkit.getVersion();
        Matcher matcher = VERSION_PATTERN.matcher(version);
        if (matcher.find()) {
            String major = matcher.group(1);
            String minor = matcher.group(2);
            String patch = matcher.group(3);
            cachedVersionParts = patch != null ? new int[]{Integer.parseInt(major), Integer.parseInt(minor), Integer.parseInt(patch)} : new int[]{Integer.parseInt(major), Integer.parseInt(minor)};
        }
    }
}

