/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrlibcore.actionbar;

import eu.mrneznamy.mrlibcore.utils.MrLibColors;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class MrLibActionBar {
    private final JavaPlugin plugin;
    private final Map<UUID, ActionBarTask> tasks = new HashMap<UUID, ActionBarTask>();

    public MrLibActionBar(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public void show(Player player, String message) {
        this.clearTask(player);
        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)MrLibColors.colorize(message, player)));
    }

    public void showTicks(Player player, String message, long ticks) {
        this.clearTask(player);
        ActionBarTask task = new ActionBarTask(player, message, ticks, false);
        this.tasks.put(player.getUniqueId(), task);
        task.start(this.plugin);
    }

    public void showSeconds(Player player, String message, int seconds) {
        this.showTicks(player, message, (long)seconds * 20L);
    }

    public void showDynamic(Player player, Function<Player, String> messageProvider, long durationTicks) {
        this.clearTask(player);
        ActionBarTask task = new ActionBarTask(player, messageProvider, durationTicks);
        this.tasks.put(player.getUniqueId(), task);
        task.start(this.plugin);
    }

    public void clear(Player player) {
        this.clearTask(player);
        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)""));
    }

    public void clearAll() {
        this.tasks.values().forEach(ActionBarTask::cancel);
        this.tasks.clear();
    }

    private void clearTask(Player player) {
        ActionBarTask task = this.tasks.remove(player.getUniqueId());
        if (task != null) {
            task.cancel();
        }
    }

    private class ActionBarTask
    implements Runnable {
        private final Player player;
        private String staticMessage;
        private Function<Player, String> dynamicMessage;
        private long remainingTicks;
        private int taskId = -1;

        public ActionBarTask(Player player, String message, long ticks, boolean unused) {
            this.player = player;
            this.staticMessage = message;
            this.remainingTicks = ticks;
        }

        public ActionBarTask(Player player, Function<Player, String> messageProvider, long ticks) {
            this.player = player;
            this.dynamicMessage = messageProvider;
            this.remainingTicks = ticks;
        }

        public void start(JavaPlugin plugin) {
            this.taskId = Bukkit.getScheduler().runTaskTimer((Plugin)plugin, (Runnable)this, 0L, 1L).getTaskId();
        }

        @Override
        public void run() {
            if (!this.player.isOnline() || this.remainingTicks <= 0L) {
                this.cancel();
                MrLibActionBar.this.tasks.remove(this.player.getUniqueId());
                return;
            }
            String message = this.dynamicMessage != null ? this.dynamicMessage.apply(this.player) : this.staticMessage;
            this.player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)MrLibColors.colorize(message, this.player)));
            --this.remainingTicks;
        }

        public void cancel() {
            if (this.taskId != -1) {
                Bukkit.getScheduler().cancelTask(this.taskId);
            }
        }
    }
}

