/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrlibcore.bossbar;

import eu.mrneznamy.mrlibcore.utils.MrLibColors;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import org.bukkit.Bukkit;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class MrLibBossBar {
    private final JavaPlugin plugin;
    private final Map<UUID, ActiveBar> activeBars = new HashMap<UUID, ActiveBar>();

    public MrLibBossBar(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public void showPermanent(Player player, String message, BarColor color, BarStyle style) {
        this.remove(player);
        BossBar bar = this.createBar(message, player, color, style, 1.0);
        bar.addPlayer(player);
        ActiveBar activeBar = new ActiveBar(bar, BarMode.PERMANENT);
        this.activeBars.put(player.getUniqueId(), activeBar);
    }

    public void showFilling(Player player, String message, BarColor color, BarStyle style, long durationTicks) {
        this.remove(player);
        BossBar bar = this.createBar(message, player, color, style, 0.0);
        bar.addPlayer(player);
        ActiveBar activeBar = new ActiveBar(bar, BarMode.FILLING);
        activeBar.totalTicks = durationTicks;
        activeBar.currentTick = 0L;
        this.activeBars.put(player.getUniqueId(), activeBar);
        this.startTask(player, activeBar);
    }

    public void showCountdown(Player player, String message, BarColor color, BarStyle style, long durationTicks) {
        this.remove(player);
        BossBar bar = this.createBar(message, player, color, style, 1.0);
        bar.addPlayer(player);
        ActiveBar activeBar = new ActiveBar(bar, BarMode.COUNTDOWN);
        activeBar.totalTicks = durationTicks;
        activeBar.currentTick = durationTicks;
        activeBar.baseMessage = message;
        this.activeBars.put(player.getUniqueId(), activeBar);
        this.startTask(player, activeBar);
    }

    public void showDynamic(Player player, Function<Player, String> messageProvider, Function<Player, Double> progressProvider, BarColor color, BarStyle style, long durationTicks) {
        this.remove(player);
        BossBar bar = this.createBar("", player, color, style, 0.0);
        bar.addPlayer(player);
        ActiveBar activeBar = new ActiveBar(bar, BarMode.DYNAMIC);
        activeBar.messageProvider = messageProvider;
        activeBar.progressProvider = progressProvider;
        activeBar.totalTicks = durationTicks;
        activeBar.currentTick = 0L;
        this.activeBars.put(player.getUniqueId(), activeBar);
        this.startTask(player, activeBar);
    }

    public void remove(Player player) {
        ActiveBar activeBar = this.activeBars.remove(player.getUniqueId());
        if (activeBar != null) {
            activeBar.cancel();
            activeBar.bar.removeAll();
        }
    }

    public void removeAll() {
        this.activeBars.values().forEach(bar -> {
            bar.cancel();
            bar.bar.removeAll();
        });
        this.activeBars.clear();
    }

    private void startTask(Player player, ActiveBar activeBar) {
        activeBar.taskId = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            if (!player.isOnline()) {
                this.remove(player);
                return;
            }
            switch (activeBar.mode.ordinal()) {
                case 1: {
                    ++activeBar.currentTick;
                    double fillProgress = Math.min(1.0, (double)activeBar.currentTick / (double)activeBar.totalTicks);
                    activeBar.bar.setProgress(fillProgress);
                    if (activeBar.currentTick < activeBar.totalTicks) break;
                    this.remove(player);
                    break;
                }
                case 2: {
                    --activeBar.currentTick;
                    double countProgress = Math.max(0.0, (double)activeBar.currentTick / (double)activeBar.totalTicks);
                    activeBar.bar.setProgress(countProgress);
                    if (activeBar.baseMessage != null && activeBar.baseMessage.contains("%time%")) {
                        int seconds = (int)(activeBar.currentTick / 20L);
                        String updated = activeBar.baseMessage.replace("%time%", String.valueOf(seconds));
                        activeBar.bar.setTitle(MrLibColors.colorize(updated, player));
                    }
                    if (activeBar.currentTick > 0L) break;
                    this.remove(player);
                    break;
                }
                case 3: {
                    ++activeBar.currentTick;
                    if (activeBar.messageProvider != null) {
                        String msg = activeBar.messageProvider.apply(player);
                        activeBar.bar.setTitle(MrLibColors.colorize(msg, player));
                    }
                    if (activeBar.progressProvider != null) {
                        double progress = Math.max(0.0, Math.min(1.0, activeBar.progressProvider.apply(player)));
                        activeBar.bar.setProgress(progress);
                    }
                    if (activeBar.currentTick < activeBar.totalTicks) break;
                    this.remove(player);
                }
            }
        }, 0L, 1L).getTaskId();
    }

    private BossBar createBar(String message, Player player, BarColor color, BarStyle style, double progress) {
        BossBar bar = Bukkit.createBossBar((String)MrLibColors.colorize(message, player), (BarColor)color, (BarStyle)style, (BarFlag[])new BarFlag[0]);
        bar.setProgress(progress);
        bar.setVisible(true);
        return bar;
    }

    private static class ActiveBar {
        BossBar bar;
        BarMode mode;
        int taskId = -1;
        long totalTicks;
        long currentTick;
        String baseMessage;
        Function<Player, String> messageProvider;
        Function<Player, Double> progressProvider;

        ActiveBar(BossBar bar, BarMode mode) {
            this.bar = bar;
            this.mode = mode;
        }

        void cancel() {
            if (this.taskId != -1) {
                Bukkit.getScheduler().cancelTask(this.taskId);
            }
        }
    }

    private static enum BarMode {
        PERMANENT,
        FILLING,
        COUNTDOWN,
        DYNAMIC;

    }
}

