/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrlibcore.config;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.file.YamlConfiguration;

public class MrLibYamlConfiguration
extends YamlConfiguration {
    private final Map<String, String> comments = new HashMap<String, String>();
    private final List<String> headerComments = new ArrayList<String>();

    public void addComment(String path, String comment) {
        if (path.equals("_HEADER_")) {
            this.headerComments.add(comment);
        } else {
            this.comments.put(path, comment);
        }
    }

    public void addComments(String path, String ... commentLines) {
        StringBuilder sb = new StringBuilder();
        for (String line : commentLines) {
            sb.append(line).append(System.lineSeparator());
        }
        this.addComment(path, sb.toString().trim());
    }

    public void setHeaderComments(List<String> comments) {
        this.headerComments.clear();
        this.headerComments.addAll(comments);
    }

    public void save(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("File cannot be null");
        }
        file.getParentFile().mkdirs();
        String yaml = this.saveToString();
        String yamlWithComments = this.insertComments(yaml);
        try (PrintWriter writer = new PrintWriter(file, StandardCharsets.UTF_8.name());){
            writer.write(yamlWithComments);
        }
    }

    private String insertComments(String yaml) {
        if (this.comments.isEmpty() && this.headerComments.isEmpty()) {
            return yaml;
        }
        StringBuilder result = new StringBuilder();
        if (!this.headerComments.isEmpty()) {
            for (String comment : this.headerComments) {
                result.append(comment).append(System.lineSeparator());
            }
            result.append(System.lineSeparator());
        }
        String[] lines = yaml.split(System.lineSeparator());
        StringBuilder currentPath = new StringBuilder();
        int depth = 0;
        for (String line : lines) {
            if (line.trim().isEmpty() && result.length() == 0) continue;
            if (this.isKeyLine(line)) {
                int lineDepth = this.getDepth(line);
                String key = this.extractKey(line);
                if (key != null && !key.isEmpty()) {
                    this.updatePath(currentPath, key, lineDepth, depth);
                    depth = lineDepth;
                    String comment = this.comments.get(currentPath.toString());
                    if (comment != null && !comment.isEmpty()) {
                        String[] commentLines;
                        String indent = this.getIndent(lineDepth);
                        for (String commentLine : commentLines = comment.split(System.lineSeparator())) {
                            result.append(indent).append(commentLine).append(System.lineSeparator());
                        }
                    }
                }
            }
            result.append(line).append(System.lineSeparator());
        }
        return result.toString();
    }

    private boolean isKeyLine(String line) {
        String trimmed = line.trim();
        return !trimmed.isEmpty() && !trimmed.startsWith("#") && !trimmed.startsWith("-") && (trimmed.contains(": ") || trimmed.endsWith(":"));
    }

    private int getDepth(String line) {
        int spaces = 0;
        for (char c : line.toCharArray()) {
            if (c != ' ') break;
            ++spaces;
        }
        return spaces / 2;
    }

    private String extractKey(String line) {
        String trimmed = line.trim();
        int colonIndex = trimmed.indexOf(58);
        if (colonIndex > 0) {
            return trimmed.substring(0, colonIndex).trim();
        }
        return null;
    }

    private void updatePath(StringBuilder currentPath, String key, int newDepth, int oldDepth) {
        if (newDepth == 0) {
            currentPath.setLength(0);
            currentPath.append(key);
        } else if (newDepth > oldDepth) {
            currentPath.append(".").append(key);
        } else if (newDepth < oldDepth) {
            int levelsUp = oldDepth - newDepth;
            for (int i = 0; i < levelsUp; ++i) {
                int lastDot = currentPath.lastIndexOf(".");
                if (lastDot <= 0) continue;
                currentPath.setLength(lastDot);
            }
            int lastDot = currentPath.lastIndexOf(".");
            if (lastDot > 0) {
                currentPath.setLength(lastDot + 1);
                currentPath.append(key);
            } else {
                currentPath.setLength(0);
                currentPath.append(key);
            }
        } else {
            int lastDot = currentPath.lastIndexOf(".");
            if (lastDot > 0) {
                currentPath.setLength(lastDot + 1);
                currentPath.append(key);
            } else {
                currentPath.setLength(0);
                currentPath.append(key);
            }
        }
    }

    private String getIndent(int depth) {
        StringBuilder indent = new StringBuilder();
        for (int i = 0; i < depth * 2; ++i) {
            indent.append(" ");
        }
        return indent.toString();
    }

    public void loadWithComments(File file) throws Exception {
        this.load(file);
    }
}

