/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrlibcore.gui;

import eu.mrneznamy.mrlibcore.gui.MrLibGUIManager;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class MrLibGUI {
    private final String title;
    private final int size;
    private final Inventory inventory;
    private final Map<Integer, Consumer<InventoryClickEvent>> clickHandlers;
    private Consumer<InventoryCloseEvent> closeHandler;
    private boolean cancelClick = true;

    public MrLibGUI(String title, int rows) {
        this.title = title;
        this.size = rows * 9;
        this.inventory = Bukkit.createInventory(null, (int)this.size, (String)title);
        this.clickHandlers = new HashMap<Integer, Consumer<InventoryClickEvent>>();
    }

    public MrLibGUI setItem(int slot, ItemStack item) {
        this.inventory.setItem(slot, item);
        return this;
    }

    public MrLibGUI setItem(int slot, ItemStack item, Consumer<InventoryClickEvent> onClick) {
        this.inventory.setItem(slot, item);
        this.clickHandlers.put(slot, onClick);
        return this;
    }

    public MrLibGUI fillEmpty(ItemStack item) {
        for (int i = 0; i < this.size; ++i) {
            if (this.inventory.getItem(i) != null) continue;
            this.inventory.setItem(i, item);
        }
        return this;
    }

    public MrLibGUI fillBorder(ItemStack item) {
        int i;
        int rows = this.size / 9;
        for (i = 0; i < 9; ++i) {
            this.inventory.setItem(i, item);
            this.inventory.setItem(this.size - 9 + i, item);
        }
        for (i = 1; i < rows - 1; ++i) {
            this.inventory.setItem(i * 9, item);
            this.inventory.setItem(i * 9 + 8, item);
        }
        return this;
    }

    public MrLibGUI onClose(Consumer<InventoryCloseEvent> handler) {
        this.closeHandler = handler;
        return this;
    }

    public MrLibGUI setCancelClick(boolean cancel) {
        this.cancelClick = cancel;
        return this;
    }

    public void open(Player player) {
        MrLibGUIManager.registerGUI(player, this);
        player.openInventory(this.inventory);
    }

    public void close(Player player) {
        player.closeInventory();
    }

    protected void handleClick(InventoryClickEvent event) {
        int slot;
        Consumer<InventoryClickEvent> handler;
        if (this.cancelClick) {
            event.setCancelled(true);
        }
        if ((handler = this.clickHandlers.get(slot = event.getRawSlot())) != null) {
            handler.accept(event);
        }
    }

    protected void handleClose(InventoryCloseEvent event) {
        if (this.closeHandler != null) {
            this.closeHandler.accept(event);
        }
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public String getTitle() {
        return this.title;
    }

    public int getSize() {
        return this.size;
    }
}

