/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrlibcore.holograms.providers;

import eu.decentsoftware.holograms.api.DHAPI;
import eu.decentsoftware.holograms.api.holograms.Hologram;
import eu.mrneznamy.mrlibcore.holograms.MrLibHologramProvider;
import eu.mrneznamy.mrlibcore.utils.MrLibColors;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;

public class MrLibDecentHologramProvider
implements MrLibHologramProvider {
    @Override
    public void createHologram(String name, Location location, List<String> lines) {
        if (!this.isEnabled()) {
            return;
        }
        try {
            List colorizedLines;
            Hologram hologram;
            Hologram existingHolo = DHAPI.getHologram((String)name);
            if (existingHolo != null) {
                existingHolo.delete();
            }
            if ((hologram = DHAPI.createHologram((String)name, (Location)location, colorizedLines = lines.stream().map(MrLibColors::colorize).collect(Collectors.toList()))) != null) {
                hologram.enable();
                if (!hologram.isEnabled()) {
                    hologram.enable();
                }
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    @Override
    public void updateHologram(String name, List<String> lines) {
        if (!this.isEnabled()) {
            return;
        }
        try {
            Hologram hologram = DHAPI.getHologram((String)name);
            if (hologram == null) {
                return;
            }
            List colorizedLines = lines.stream().map(MrLibColors::colorize).collect(Collectors.toList());
            DHAPI.setHologramLines((Hologram)hologram, colorizedLines);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    @Override
    public void deleteHologram(String name) {
        if (!this.isEnabled()) {
            return;
        }
        try {
            Hologram hologram = DHAPI.getHologram((String)name);
            if (hologram != null) {
                hologram.delete();
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    @Override
    public boolean isEnabled() {
        try {
            return Bukkit.getPluginManager().getPlugin("DecentHolograms") != null;
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
    }

    @Override
    public boolean hologramExists(String name) {
        if (!this.isEnabled()) {
            return false;
        }
        try {
            return DHAPI.getHologram((String)name) != null;
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
    }

    @Override
    public String getProviderName() {
        return "DecentHolograms";
    }
}

