/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrlibcore.holograms.providers;

import eu.mrneznamy.mrlibcore.holograms.MrLibHologramProvider;
import eu.mrneznamy.mrlibcore.holograms.entities.MrLibEntityHologramManager;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;

public class MrLibEntityHologramProvider
implements MrLibHologramProvider {
    private final MrLibEntityHologramManager manager;
    private final Plugin plugin;

    public MrLibEntityHologramProvider(Plugin plugin) {
        this.plugin = plugin;
        this.manager = MrLibEntityHologramManager.getInstance(plugin);
    }

    @Override
    public void createHologram(String name, Location location, List<String> lines) {
        if (this.manager != null) {
            this.manager.createHologram(name, location, lines);
        }
    }

    @Override
    public void updateHologram(String name, List<String> lines) {
        if (this.manager != null) {
            this.manager.updateHologram(name, lines);
        }
    }

    @Override
    public void deleteHologram(String name) {
        if (this.manager != null) {
            this.manager.removeHologram(name);
        }
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public boolean hologramExists(String name) {
        return this.manager != null && this.manager.hologramExists(name);
    }

    @Override
    public String getProviderName() {
        return "MrLibCore-Entity";
    }

    public String getPerformanceStats() {
        return this.manager != null ? this.manager.getPerformanceStats() : "Manager not initialized";
    }

    public void forceUpdateAll() {
        if (this.manager != null) {
            this.manager.forceUpdateAll();
        }
    }

    public void cleanup() {
        if (this.manager != null) {
            this.manager.removeAllHolograms();
        }
    }

    public void cleanupAllHolograms() {
        this.cleanup();
    }

    public void shutdown() {
        if (this.manager != null) {
            this.manager.shutdown();
        }
    }
}

