/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrlibcore.holograms.providers;

import eu.mrneznamy.mrlibcore.holograms.MrLibHologramProvider;
import eu.mrneznamy.mrlibcore.holograms.displays.MrLibTextDisplayHologramManager;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;

public class MrLibTextDisplayHologramProvider
implements MrLibHologramProvider {
    private final MrLibTextDisplayHologramManager manager;
    private final Plugin plugin;

    public MrLibTextDisplayHologramProvider(Plugin plugin) {
        this.plugin = plugin;
        this.manager = MrLibTextDisplayHologramManager.getInstance(plugin);
    }

    @Override
    public void createHologram(String name, Location location, List<String> lines) {
        if (this.manager != null) {
            this.manager.createHologram(name, location, lines);
        }
    }

    @Override
    public void updateHologram(String name, List<String> lines) {
        if (this.manager != null) {
            this.manager.updateHologram(name, lines);
        }
    }

    @Override
    public void deleteHologram(String name) {
        if (this.manager != null) {
            this.manager.removeHologram(name);
        }
    }

    @Override
    public boolean isEnabled() {
        try {
            Class.forName("org.bukkit.entity.TextDisplay");
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    @Override
    public boolean hologramExists(String name) {
        return this.manager != null && this.manager.hologramExists(name);
    }

    @Override
    public String getProviderName() {
        return "MrLibCore-TextDisplay";
    }

    public String getPerformanceStats() {
        return this.manager != null ? this.manager.getPerformanceStats() : "Manager not initialized";
    }

    public void cleanupAllHolograms() {
        if (this.manager != null) {
            this.manager.removeAllHolograms();
        }
    }

    public void forceUpdateAll() {
        if (this.manager != null) {
            this.manager.forceUpdateAll();
        }
    }

    public void shutdown() {
        if (this.manager != null) {
            this.manager.shutdown();
        }
    }
}

