/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrlibcore.placeholders;

import eu.mrneznamy.mrlibcore.placeholders.MrLibPlaceholder;
import eu.mrneznamy.mrlibcore.placeholders.MrLibPlaceholderExpansion;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class MrLibRegisterPlaceholders {
    private static final Map<String, Map<String, MrLibPlaceholder>> placeholders = new HashMap<String, Map<String, MrLibPlaceholder>>();
    private static boolean expansionRegistered = false;

    public static void register(String pluginName, String placeholderName, MrLibPlaceholder handler) {
        pluginName = pluginName.toLowerCase();
        placeholderName = placeholderName.toLowerCase();
        placeholders.computeIfAbsent(pluginName, k -> new HashMap()).put(placeholderName, handler);
        if (!expansionRegistered && MrLibRegisterPlaceholders.isPlaceholderAPIAvailable()) {
            MrLibRegisterPlaceholders.registerExpansion();
            expansionRegistered = true;
        }
    }

    public static String getPlaceholder(String pluginName, String placeholderName, Player player, String params) {
        Map<String, MrLibPlaceholder> pluginPlaceholders = placeholders.get(pluginName.toLowerCase());
        if (pluginPlaceholders == null) {
            return null;
        }
        MrLibPlaceholder handler = pluginPlaceholders.get(placeholderName.toLowerCase());
        if (handler == null) {
            return null;
        }
        try {
            return handler.onRequest(player, params);
        }
        catch (Exception e) {
            return "Error: " + e.getMessage();
        }
    }

    private static boolean isPlaceholderAPIAvailable() {
        return Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null;
    }

    private static void registerExpansion() {
        try {
            new MrLibPlaceholderExpansion().register();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Map<String, Map<String, MrLibPlaceholder>> getAllPlaceholders() {
        return new HashMap<String, Map<String, MrLibPlaceholder>>(placeholders);
    }
}

