/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrlibcore.title;

import eu.mrneznamy.mrlibcore.utils.MrLibColors;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class MrLibTitle {
    private final JavaPlugin plugin;
    private final Map<UUID, TitleTask> activeTitles = new HashMap<UUID, TitleTask>();

    public MrLibTitle(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public void show(Player player, String title, String subtitle, int fadeIn, int stay, int fadeOut) {
        this.clearTitle(player);
        player.sendTitle(MrLibColors.colorize(title, player), MrLibColors.colorize(subtitle, player), fadeIn, stay, fadeOut);
    }

    public void showRepeating(Player player, Function<Player, String> titleProvider, Function<Player, String> subtitleProvider, long intervalTicks, long durationTicks) {
        this.clearTitle(player);
        TitleTask task = new TitleTask(player, titleProvider, subtitleProvider, intervalTicks, durationTicks);
        this.activeTitles.put(player.getUniqueId(), task);
        task.start(this.plugin);
    }

    public void showCountdown(Player player, String titleFormat, String subtitle, int seconds) {
        this.clearTitle(player);
        int[] remaining = new int[]{seconds};
        TitleTask task = new TitleTask(player, p -> titleFormat.replace("%time%", String.valueOf(remaining[0])), p -> subtitle, 20L, (long)seconds * 20L);
        task.onTick = () -> {
            remaining[0] = remaining[0] - 1;
        };
        this.activeTitles.put(player.getUniqueId(), task);
        task.start(this.plugin);
    }

    public void showSequence(Player player, TitleSequence ... sequences) {
        this.clearTitle(player);
        this.showNextSequence(player, sequences, 0);
    }

    private void showNextSequence(Player player, TitleSequence[] sequences, int index) {
        if (index >= sequences.length || !player.isOnline()) {
            return;
        }
        TitleSequence seq = sequences[index];
        this.show(player, seq.title, seq.subtitle, seq.fadeIn, seq.stay, seq.fadeOut);
        if (index + 1 < sequences.length) {
            long delay = seq.fadeIn + seq.stay + seq.fadeOut;
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.showNextSequence(player, sequences, index + 1), delay);
        }
    }

    public void clearTitle(Player player) {
        TitleTask task = this.activeTitles.remove(player.getUniqueId());
        if (task != null) {
            task.cancel();
        }
        player.resetTitle();
    }

    public void clearAll() {
        this.activeTitles.values().forEach(TitleTask::cancel);
        this.activeTitles.clear();
    }

    private class TitleTask
    implements Runnable {
        private final Player player;
        private final Function<Player, String> titleProvider;
        private final Function<Player, String> subtitleProvider;
        private final long intervalTicks;
        private long remainingTicks;
        private int taskId = -1;
        private Runnable onTick;

        public TitleTask(Player player, Function<Player, String> titleProvider, Function<Player, String> subtitleProvider, long intervalTicks, long durationTicks) {
            this.player = player;
            this.titleProvider = titleProvider;
            this.subtitleProvider = subtitleProvider;
            this.intervalTicks = intervalTicks;
            this.remainingTicks = durationTicks;
        }

        public void start(JavaPlugin plugin) {
            this.taskId = Bukkit.getScheduler().runTaskTimer((Plugin)plugin, (Runnable)this, 0L, this.intervalTicks).getTaskId();
        }

        @Override
        public void run() {
            if (!this.player.isOnline() || this.remainingTicks <= 0L) {
                this.cancel();
                MrLibTitle.this.activeTitles.remove(this.player.getUniqueId());
                return;
            }
            String title = this.titleProvider.apply(this.player);
            String subtitle = this.subtitleProvider != null ? this.subtitleProvider.apply(this.player) : "";
            this.player.sendTitle(MrLibColors.colorize(title, this.player), MrLibColors.colorize(subtitle, this.player), 5, (int)this.intervalTicks, 5);
            if (this.onTick != null) {
                this.onTick.run();
            }
            this.remainingTicks -= this.intervalTicks;
        }

        public void cancel() {
            if (this.taskId != -1) {
                Bukkit.getScheduler().cancelTask(this.taskId);
            }
        }
    }

    public static class TitleSequence {
        String title;
        String subtitle;
        int fadeIn;
        int stay;
        int fadeOut;

        public TitleSequence(String title, String subtitle, int fadeIn, int stay, int fadeOut) {
            this.title = title;
            this.subtitle = subtitle;
            this.fadeIn = fadeIn;
            this.stay = stay;
            this.fadeOut = fadeOut;
        }

        public static TitleSequence of(String title, String subtitle) {
            return new TitleSequence(title, subtitle, 10, 70, 20);
        }
    }
}

