/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrlibcore.utils;

import eu.mrneznamy.mrlibcore.utils.MrLibConsoleSayer;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class MrLibUpdateChecker {
    private final JavaPlugin plugin;
    private final String modrinthSlug;

    public MrLibUpdateChecker(JavaPlugin plugin, String modrinthSlug) {
        this.plugin = plugin;
        this.modrinthSlug = modrinthSlug;
    }

    public void fetchLatestVersion(Consumer<String> callback) {
        MrLibUpdateChecker.fetchLatestVersion(this.plugin, this.modrinthSlug, callback);
    }

    public static void fetchLatestVersion(JavaPlugin plugin, String modrinthSlug, Consumer<String> callback) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
            try {
                HttpURLConnection conn = (HttpURLConnection)new URL("https://api.modrinth.com/v2/project/" + modrinthSlug + "/version").openConnection();
                conn.setRequestProperty("User-Agent", plugin.getName());
                conn.setConnectTimeout(3000);
                conn.setReadTimeout(3000);
                BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                String line = reader.readLine();
                reader.close();
                if (line != null && line.contains("version_number")) {
                    String version = line.split("\"version_number\":\"")[1].split("\"")[0];
                    Bukkit.getScheduler().runTask((Plugin)plugin, () -> callback.accept(version));
                }
            }
            catch (Exception e) {
                MrLibConsoleSayer.MrSay_Error("Update check failed for " + plugin.getName() + ": " + e.getMessage());
            }
        });
    }

    public static void checkAndPrintVersion(JavaPlugin plugin, String modrinthSlug) {
        MrLibUpdateChecker.fetchLatestVersion(plugin, modrinthSlug, latestVersion -> {
            String currentVersion = plugin.getDescription().getVersion();
            if (!currentVersion.equals(latestVersion)) {
                MrLibConsoleSayer.MrSay_Info("[" + plugin.getName() + "] Update available! Current: " + currentVersion + ", Latest: " + latestVersion);
                MrLibConsoleSayer.MrSay_Info("[" + plugin.getName() + "] Download: https://modrinth.com/plugin/" + modrinthSlug);
            } else {
                MrLibConsoleSayer.MrSay_Success("[" + plugin.getName() + "] Version " + currentVersion + " is up to date!");
            }
        });
    }
}

