/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrcommunityquest;

import eu.mrneznamy.mrcommunityquest.commands.AdminCommand;
import eu.mrneznamy.mrcommunityquest.commands.CommunityQuestCommand;
import eu.mrneznamy.mrcommunityquest.data.PlayerSettingsManager;
import eu.mrneznamy.mrcommunityquest.data.QuestProgressManager;
import eu.mrneznamy.mrcommunityquest.display.ProgressMessageManager;
import eu.mrneznamy.mrcommunityquest.economy.EconomyManager;
import eu.mrneznamy.mrcommunityquest.gui.GUIListener;
import eu.mrneznamy.mrcommunityquest.gui.QuestGUI;
import eu.mrneznamy.mrcommunityquest.hooks.PlaceholderAPIExpansion;
import eu.mrneznamy.mrcommunityquest.listener.BlockBreakListener;
import eu.mrneznamy.mrcommunityquest.listener.MrAuctionsBidListener;
import eu.mrneznamy.mrcommunityquest.listener.MrUltimateFishingListener;
import eu.mrneznamy.mrcommunityquest.listener.MrUltimateJobsListener;
import eu.mrneznamy.mrcommunityquest.listener.MrUltimateShopListener;
import eu.mrneznamy.mrcommunityquest.listener.NuVotifierListener;
import eu.mrneznamy.mrcommunityquest.managers.ConfigManager;
import eu.mrneznamy.mrcommunityquest.managers.MessageManager;
import eu.mrneznamy.mrcommunityquest.quests.CommunityQuestManager;
import eu.mrneznamy.mrcommunityquest.rewards.RewardsManager;
import eu.mrneznamy.mrcommunityquest.scheduler.AutoScheduler;
import eu.mrneznamy.mrcommunityquest.utils.CheckUpdates;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class MrCommunityQuest
extends JavaPlugin
implements Listener {
    private static MrCommunityQuest instance;
    private ConfigManager configManager;
    private MessageManager messageManager;
    private CommunityQuestManager questManager;
    private QuestGUI questGUI;
    private GUIListener guiListener;
    private BlockBreakListener blockBreakListener;
    private NuVotifierListener nuVotifierListener;
    private MrUltimateShopListener mrUltimateShopListener;
    private MrUltimateFishingListener mrUltimateFishingListener;
    private MrAuctionsBidListener mrAuctionsBidListener;
    private MrUltimateJobsListener mrUltimateJobsListener;
    private RewardsManager rewardsManager;
    private AutoScheduler autoScheduler;
    private PlayerSettingsManager playerSettingsManager;
    private ProgressMessageManager progressMessageManager;
    private EconomyManager economyManager;
    private QuestProgressManager questProgressManager;
    private CheckUpdates checkUpdates;
    private PlaceholderAPIExpansion placeholderAPIExpansion;
    private FileConfiguration questsConfig;
    private FileConfiguration guiConfig;

    public void onEnable() {
        instance = this;
        this.configManager = new ConfigManager(this);
        this.configManager.loadConfig();
        this.messageManager = new MessageManager(this);
        this.questProgressManager = new QuestProgressManager(this);
        this.questManager = new CommunityQuestManager(this);
        this.rewardsManager = new RewardsManager(this);
        this.economyManager = new EconomyManager(this);
        this.playerSettingsManager = new PlayerSettingsManager(this);
        this.progressMessageManager = new ProgressMessageManager(this);
        this.questsConfig = this.configManager.loadQuestsConfig();
        this.guiConfig = this.configManager.loadGUIConfig();
        this.messageManager.loadMessages();
        this.questGUI = new QuestGUI(this);
        this.guiListener = new GUIListener(this);
        this.blockBreakListener = new BlockBreakListener(this);
        this.nuVotifierListener = new NuVotifierListener(this);
        this.mrUltimateShopListener = new MrUltimateShopListener(this);
        this.mrUltimateFishingListener = new MrUltimateFishingListener(this);
        this.mrAuctionsBidListener = new MrAuctionsBidListener(this);
        this.mrUltimateJobsListener = new MrUltimateJobsListener(this);
        this.autoScheduler = new AutoScheduler(this);
        this.autoScheduler.startScheduler();
        this.getCommand("mqc").setExecutor((CommandExecutor)new AdminCommand(this));
        this.getCommand("cq").setExecutor((CommandExecutor)new CommunityQuestCommand(this));
        this.getCommand("cquest").setExecutor((CommandExecutor)new CommunityQuestCommand(this));
        Bukkit.getPluginManager().registerEvents((Listener)this.guiListener, (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)this.blockBreakListener, (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)this.nuVotifierListener, (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)this.mrUltimateShopListener, (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)this.mrUltimateFishingListener, (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)this.mrAuctionsBidListener, (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)this.mrUltimateJobsListener, (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            this.placeholderAPIExpansion = new PlaceholderAPIExpansion(this);
            this.placeholderAPIExpansion.register();
        }
        this.checkUpdates = new CheckUpdates(this);
        this.checkUpdates.EnableMessage();
        this.checkUpdates.checkForUpdates();
    }

    public void onDisable() {
        if (this.questManager != null) {
            this.questManager.saveAllPlayerData();
        }
        if (this.playerSettingsManager != null) {
            this.playerSettingsManager.saveAllPlayerSettings();
        }
        if (this.autoScheduler != null) {
            this.autoScheduler.stopScheduler();
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (this.questManager != null && this.questManager.getPlaceholderQuestManager() != null) {
            this.questManager.getPlaceholderQuestManager().onPlayerJoin(event.getPlayer());
        }
    }

    public static MrCommunityQuest getInstance() {
        return instance;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public MessageManager getMessageManager() {
        return this.messageManager;
    }

    public CommunityQuestManager getQuestManager() {
        return this.questManager;
    }

    public QuestGUI getQuestGUI() {
        return this.questGUI;
    }

    public AutoScheduler getAutoScheduler() {
        return this.autoScheduler;
    }

    public PlayerSettingsManager getPlayerSettingsManager() {
        return this.playerSettingsManager;
    }

    public ProgressMessageManager getProgressMessageManager() {
        return this.progressMessageManager;
    }

    public EconomyManager getEconomyManager() {
        return this.economyManager;
    }

    public RewardsManager getRewardsManager() {
        return this.rewardsManager;
    }

    public FileConfiguration getQuestsConfig() {
        return this.questsConfig;
    }

    public FileConfiguration getGUIConfig() {
        return this.guiConfig;
    }

    public QuestProgressManager getQuestProgressManager() {
        return this.questProgressManager;
    }

    public PlaceholderAPIExpansion getPlaceholderAPIExpansion() {
        return this.placeholderAPIExpansion;
    }

    public MrUltimateShopListener getMrUltimateShopListener() {
        return this.mrUltimateShopListener;
    }

    public MrUltimateFishingListener getMrUltimateFishingListener() {
        return this.mrUltimateFishingListener;
    }

    public MrAuctionsBidListener getMrAuctionsBidListener() {
        return this.mrAuctionsBidListener;
    }

    public void reloadConfiguration() {
        this.configManager.reloadConfig();
        this.questsConfig = this.configManager.loadQuestsConfig();
        this.guiConfig = this.configManager.loadGUIConfig();
        if (this.messageManager != null) {
            this.messageManager.reloadMessages();
        }
        if (this.autoScheduler != null) {
            this.autoScheduler.reload();
        }
        if (this.questManager != null) {
            // empty if block
        }
    }
}

