/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrcommunityquest.data;

import java.util.UUID;

public class PlayerData {
    private final UUID playerId;
    private int blocksBroken;
    private int entitiesKilled;
    private double donateAmount;
    private int expDonateAmount;
    private int levelDonateAmount;
    private boolean participated;

    public PlayerData(UUID playerId) {
        this.playerId = playerId;
        this.blocksBroken = 0;
        this.entitiesKilled = 0;
        this.donateAmount = 0.0;
        this.expDonateAmount = 0;
        this.levelDonateAmount = 0;
        this.participated = false;
    }

    public UUID getPlayerId() {
        return this.playerId;
    }

    public int getBlocksBroken() {
        return this.blocksBroken;
    }

    public int getEntitiesKilled() {
        return this.entitiesKilled;
    }

    public double getDonateAmount() {
        return this.donateAmount;
    }

    public int getExpDonateAmount() {
        return this.expDonateAmount;
    }

    public int getLevelDonateAmount() {
        return this.levelDonateAmount;
    }

    public boolean hasParticipated() {
        return this.participated;
    }

    public void setBlocksBroken(int blocksBroken) {
        this.blocksBroken = blocksBroken;
        this.checkParticipation();
    }

    public void setEntitiesKilled(int entitiesKilled) {
        this.entitiesKilled = entitiesKilled;
        this.checkParticipation();
    }

    public void setDonateAmount(double donateAmount) {
        this.donateAmount = donateAmount;
        this.checkParticipation();
    }

    public void setExpDonateAmount(int expDonateAmount) {
        this.expDonateAmount = expDonateAmount;
        this.checkParticipation();
    }

    public void setLevelDonateAmount(int levelDonateAmount) {
        this.levelDonateAmount = levelDonateAmount;
        this.checkParticipation();
    }

    public void setParticipated(boolean participated) {
        this.participated = participated;
    }

    public void incrementBlocksBroken() {
        ++this.blocksBroken;
        this.checkParticipation();
    }

    public void incrementEntitiesKilled() {
        ++this.entitiesKilled;
        this.checkParticipation();
    }

    public void addDonateAmount(double amount) {
        this.donateAmount += amount;
        this.checkParticipation();
    }

    public void addExpDonateAmount(int amount) {
        this.expDonateAmount += amount;
        this.checkParticipation();
    }

    public void addLevelDonateAmount(int amount) {
        this.levelDonateAmount += amount;
        this.checkParticipation();
    }

    private void checkParticipation() {
        if (!this.participated && (this.blocksBroken > 0 || this.donateAmount > 0.0 || this.expDonateAmount > 0 || this.levelDonateAmount > 0)) {
            this.participated = true;
        }
    }
}

