/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrcommunityquest.display;

import eu.mrneznamy.mrcommunityquest.MrCommunityQuest;
import eu.mrneznamy.mrcommunityquest.utils.ColorSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class ProgressMessageManager {
    private final MrCommunityQuest plugin;
    private BukkitTask progressMessageTask;
    private final Map<UUID, Set<String>> playerLastProgress;
    private final Set<String> sentThresholds;
    private final Map<String, Map<UUID, Integer>> lastPlayerProgress;

    public ProgressMessageManager(MrCommunityQuest plugin) {
        this.plugin = plugin;
        this.playerLastProgress = new HashMap<UUID, Set<String>>();
        this.sentThresholds = new HashSet<String>();
        this.lastPlayerProgress = new HashMap<String, Map<UUID, Integer>>();
        this.startProgressMessageUpdater();
    }

    private void startProgressMessageUpdater() {
        this.progressMessageTask = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, this::sendProgressMessages, 20L, 600L);
    }

    public void sendImmediateProgressMessage(String questId, int threshold) {
        if (!this.plugin.getConfig().getBoolean("MrCommunityQuest.ProgressMessages.Enabled", true)) {
            return;
        }
        ConfigurationSection questSection = this.plugin.getQuestsConfig().getConfigurationSection("MrCommunityQuest.Quests." + questId + ".Quest");
        if (questSection == null) {
            return;
        }
        ConfigurationSection messagesSection = questSection.getConfigurationSection("Messages");
        if (messagesSection == null) {
            return;
        }
        if (!messagesSection.contains("Progress")) {
            return;
        }
        List progressMessages = messagesSection.getStringList("Progress");
        int requiredAmount = questSection.getInt("Amount", 0);
        int totalProgress = this.plugin.getQuestManager().getQuestTracker().getQuestProgress(questId).values().stream().mapToInt(Integer::intValue).sum();
        if (requiredAmount <= 0) {
            return;
        }
        int percentage = (int)Math.floor((double)totalProgress * 100.0 / (double)requiredAmount);
        String thresholdKey = questId + "_" + threshold;
        this.sentThresholds.add(thresholdKey);
        for (String message : progressMessages) {
            message = message.replace("[progress]", String.valueOf(totalProgress)).replace("[amount]", String.valueOf(requiredAmount)).replace("[percentage]", String.valueOf(percentage)).replace("[threshold]", String.valueOf(threshold));
            Map<UUID, Integer> progressMap = this.plugin.getQuestManager().getQuestTracker().getQuestProgress(questId);
            ArrayList<Map.Entry<UUID, Integer>> sortedProgress = new ArrayList<Map.Entry<UUID, Integer>>(progressMap.entrySet());
            Collections.sort(sortedProgress, (e1, e2) -> ((Integer)e2.getValue()).compareTo((Integer)e1.getValue()));
            for (int i = 1; i <= 10; ++i) {
                if (sortedProgress.size() >= i) {
                    Map.Entry playerEntry = (Map.Entry)sortedProgress.get(i - 1);
                    String playerName = Bukkit.getOfflinePlayer((UUID)((UUID)playerEntry.getKey())).getName();
                    if (playerName == null) {
                        playerName = "Unknown";
                    }
                    message = message.replace("[PlayerName-" + i + "]", playerName);
                    message = message.replace("[Amount-" + i + "]", String.valueOf(playerEntry.getValue()));
                    continue;
                }
                message = message.replace("[PlayerName-" + i + "]", "None");
                message = message.replace("[Amount-" + i + "]", "0");
            }
            for (Player player : Bukkit.getOnlinePlayers()) {
                int playerProgress = this.plugin.getQuestManager().getQuestTracker().getPlayerProgress(questId, player.getUniqueId());
                int playerPosition = -1;
                int playerAmount = playerProgress;
                for (int i = 0; i < sortedProgress.size(); ++i) {
                    if (!((UUID)((Map.Entry)sortedProgress.get(i)).getKey()).equals(player.getUniqueId())) continue;
                    playerPosition = i + 1;
                    playerAmount = (Integer)((Map.Entry)sortedProgress.get(i)).getValue();
                    break;
                }
                if (playerPosition == -1) {
                    playerPosition = sortedProgress.size() + 1;
                }
                String playerMessage = message.replace("[My-Position]", String.valueOf(playerPosition));
                playerMessage = playerMessage.replace("[My-Amount]", String.valueOf(playerAmount));
                playerMessage = ColorSystem.colorize(playerMessage);
                Bukkit.broadcastMessage((String)playerMessage);
            }
        }
    }

    private void sendProgressMessages() {
        String[] progressStrings;
        if (!this.plugin.getConfig().getBoolean("MrCommunityQuest.ProgressMessages.Enabled", true)) {
            return;
        }
        HashSet<Integer> progressThresholds = new HashSet<Integer>();
        for (String progressStr : progressStrings = this.plugin.getConfig().getString("MrCommunityQuest.ProgressMessages.Progress", "10,20,30,40,50,60,70,80,90").split(",")) {
            try {
                progressThresholds.add(Integer.parseInt(progressStr.trim()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        Map<String, Long> activeQuests = this.plugin.getQuestGUI().getActiveQuests();
        if (activeQuests.isEmpty()) {
            return;
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.playerLastProgress.putIfAbsent(player.getUniqueId(), new HashSet());
            Set<String> playerLastProgressSet = this.playerLastProgress.get(player.getUniqueId());
            for (Map.Entry<String, Long> entry : activeQuests.entrySet()) {
                ConfigurationSection messagesSection;
                String questId = entry.getKey();
                this.lastPlayerProgress.putIfAbsent(questId, new HashMap());
                Map<UUID, Integer> questLastProgress = this.lastPlayerProgress.get(questId);
                ConfigurationSection questSection = this.plugin.getQuestsConfig().getConfigurationSection("MrCommunityQuest.Quests." + questId + ".Quest");
                if (questSection == null || (messagesSection = questSection.getConfigurationSection("Messages")) == null || !messagesSection.contains("Progress")) continue;
                List progressMessages = messagesSection.getStringList("Progress");
                int requiredAmount = questSection.getInt("Amount", 0);
                int totalProgress = this.plugin.getQuestManager().getQuestTracker().getQuestProgress(questId).values().stream().mapToInt(Integer::intValue).sum();
                if (requiredAmount <= 0) continue;
                int percentage = (int)Math.floor((double)totalProgress * 100.0 / (double)requiredAmount);
                int lastPercentage = questLastProgress.getOrDefault(player.getUniqueId(), 0);
                questLastProgress.put(player.getUniqueId(), percentage);
                if (percentage <= lastPercentage) continue;
                boolean shouldSend = false;
                String thresholdToSend = null;
                for (Integer threshold : progressThresholds) {
                    String thresholdKey;
                    if (lastPercentage >= threshold || percentage < threshold || this.sentThresholds.contains(thresholdKey = questId + "_" + threshold)) continue;
                    shouldSend = true;
                    thresholdToSend = String.valueOf(threshold);
                    this.sentThresholds.add(thresholdKey);
                    break;
                }
                if (!shouldSend) continue;
                for (String message : progressMessages) {
                    message = message.replace("[progress]", String.valueOf(totalProgress)).replace("[amount]", String.valueOf(requiredAmount)).replace("[percentage]", String.valueOf(percentage)).replace("[threshold]", thresholdToSend);
                    Map<UUID, Integer> progressMap = this.plugin.getQuestManager().getQuestTracker().getQuestProgress(questId);
                    ArrayList<Map.Entry<UUID, Integer>> sortedProgress = new ArrayList<Map.Entry<UUID, Integer>>(progressMap.entrySet());
                    Collections.sort(sortedProgress, (e1, e2) -> ((Integer)e2.getValue()).compareTo((Integer)e1.getValue()));
                    for (int i = 1; i <= 10; ++i) {
                        if (sortedProgress.size() >= i) {
                            Map.Entry playerEntry = (Map.Entry)sortedProgress.get(i - 1);
                            String playerName = Bukkit.getOfflinePlayer((UUID)((UUID)playerEntry.getKey())).getName();
                            if (playerName == null) {
                                playerName = "Unknown";
                            }
                            message = message.replace("[PlayerName-" + i + "]", playerName);
                            message = message.replace("[Amount-" + i + "]", String.valueOf(playerEntry.getValue()));
                            continue;
                        }
                        message = message.replace("[PlayerName-" + i + "]", "None");
                        message = message.replace("[Amount-" + i + "]", "0");
                    }
                    int playerProgress = this.plugin.getQuestManager().getQuestTracker().getPlayerProgress(questId, player.getUniqueId());
                    int playerPosition = -1;
                    int playerAmount = playerProgress;
                    for (int i = 0; i < sortedProgress.size(); ++i) {
                        if (!((UUID)((Map.Entry)sortedProgress.get(i)).getKey()).equals(player.getUniqueId())) continue;
                        playerPosition = i + 1;
                        playerAmount = (Integer)((Map.Entry)sortedProgress.get(i)).getValue();
                        break;
                    }
                    if (playerPosition == -1) {
                        playerPosition = sortedProgress.size() + 1;
                    }
                    message = message.replace("[My-Position]", String.valueOf(playerPosition));
                    message = message.replace("[My-Amount]", String.valueOf(playerAmount));
                    message = ColorSystem.colorize(message);
                    Bukkit.broadcastMessage((String)message);
                }
            }
        }
    }

    public void stopProgressMessageUpdater() {
        if (this.progressMessageTask != null) {
            this.progressMessageTask.cancel();
        }
    }

    public void resetPlayerProgress(UUID playerId) {
        this.playerLastProgress.remove(playerId);
        for (Map<UUID, Integer> questProgress : this.lastPlayerProgress.values()) {
            questProgress.remove(playerId);
        }
    }

    public void resetQuestThresholds(String questId) {
        this.sentThresholds.removeIf(key -> key.startsWith(questId + "_"));
        this.lastPlayerProgress.remove(questId);
    }
}

