/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrcommunityquest.listener;

import eu.mrneznamy.mrcommunityquest.MrCommunityQuest;
import eu.mrneznamy.mrcommunityquest.data.PlayerData;
import eu.mrneznamy.mrcommunityquest.gui.QuestGUI;
import eu.mrneznamy.mrcommunityquest.quests.CommunityQuestManager;
import java.util.List;
import java.util.UUID;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.plugin.Plugin;

public class BlockBreakListener
implements Listener {
    private final MrCommunityQuest plugin;

    public BlockBreakListener(MrCommunityQuest plugin) {
        this.plugin = plugin;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        if (this.isWorldDisabled(event.getBlock().getWorld().getName())) {
            return;
        }
        CommunityQuestManager questManager = this.plugin.getQuestManager();
        if (questManager == null) {
            return;
        }
        if (!this.hasActiveBreakQuests()) {
            return;
        }
        if (!this.canPlayerParticipateInQuests(player)) {
            return;
        }
        PlayerData playerData = questManager.getDataManager().getPlayerData(playerId);
        playerData.incrementBlocksBroken();
        String blockType = event.getBlock().getType().name();
        questManager.updateBreakQuestProgress(playerId, blockType);
    }

    private boolean canPlayerParticipateInQuests(Player player) {
        FileConfiguration questsConfig = this.plugin.getQuestsConfig();
        if (questsConfig == null) {
            return true;
        }
        QuestGUI questGUI = this.plugin.getQuestGUI();
        if (questGUI == null) {
            return true;
        }
        ConfigurationSection questsSection = questsConfig.getConfigurationSection("MrCommunityQuest.Quests");
        if (questsSection != null) {
            for (String questKey : questsSection.getKeys(false)) {
                ConfigurationSection questSection = questsSection.getConfigurationSection(questKey + ".Quest");
                if (questSection == null) continue;
                String provider = questSection.getString("Provider", "VANILLA");
                String type = questSection.getString("Type", "BREAK");
                if (!"VANILLA".equalsIgnoreCase(provider) || !"BREAK".equalsIgnoreCase(type) || !questGUI.isQuestActive(questKey)) continue;
                String permission = questSection.getString("Permission", "");
                if (!permission.isEmpty()) {
                    if (!player.hasPermission(permission)) continue;
                    return true;
                }
                return true;
            }
        }
        return false;
    }

    private boolean hasActiveBreakQuests() {
        FileConfiguration questsConfig = this.plugin.getQuestsConfig();
        if (questsConfig == null) {
            return false;
        }
        QuestGUI questGUI = this.plugin.getQuestGUI();
        if (questGUI == null) {
            return false;
        }
        ConfigurationSection questsSection = questsConfig.getConfigurationSection("MrCommunityQuest.Quests");
        if (questsSection != null) {
            for (String questKey : questsSection.getKeys(false)) {
                ConfigurationSection questSection = questsSection.getConfigurationSection(questKey + ".Quest");
                if (questSection == null) continue;
                String provider = questSection.getString("Provider", "VANILLA");
                String type = questSection.getString("Type", "BREAK");
                if (!"VANILLA".equalsIgnoreCase(provider) || !"BREAK".equalsIgnoreCase(type) || !questGUI.isQuestActive(questKey)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isWorldDisabled(String worldName) {
        FileConfiguration config = this.plugin.getConfig();
        if (config == null) {
            return false;
        }
        List disabledWorlds = config.getStringList("MrCommunityQuest.Settings.Disabled-Worlds");
        return disabledWorlds.contains(worldName);
    }
}

