/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrcommunityquest.commands;

import eu.mrneznamy.mrcommunityquest.MrCommunityQuest;
import eu.mrneznamy.mrcommunityquest.utils.ColorSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public class AdminCommand
implements CommandExecutor,
TabCompleter {
    private final MrCommunityQuest plugin;

    public AdminCommand(MrCommunityQuest plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            this.sendHelp(sender);
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "help": {
                this.sendHelp(sender);
                return true;
            }
            case "reload": {
                this.plugin.reloadConfiguration();
                sender.sendMessage(this.plugin.getMessageManager().getMessage("general.config-loaded"));
                return true;
            }
            case "start": {
                if (args.length < 2) {
                    sender.sendMessage(this.plugin.getMessageManager().getMessage("general.invalid-command"));
                    return true;
                }
                this.startQuest(sender, args[1]);
                return true;
            }
            case "end": {
                if (args.length < 2) {
                    sender.sendMessage(this.plugin.getMessageManager().getMessage("general.invalid-command"));
                    return true;
                }
                this.endQuest(sender, args[1]);
                return true;
            }
        }
        sender.sendMessage(this.plugin.getMessageManager().getMessage("general.invalid-command"));
        return true;
    }

    private void startQuest(CommandSender sender, String questId) {
        if (!this.plugin.getQuestsConfig().contains("MrCommunityQuest.Quests." + questId)) {
            sender.sendMessage(this.plugin.getMessageManager().getMessage("quests.quest-not-found").replace("[quest-id]", questId));
            return;
        }
        if (this.plugin.getQuestGUI().isQuestActive(questId)) {
            sender.sendMessage(this.plugin.getMessageManager().getMessage("quests.quest-already-active").replace("[quest-id]", questId));
            return;
        }
        long durationSeconds = 3600L;
        if (this.plugin.getQuestsConfig().contains("MrCommunityQuest.Quests." + questId + ".Quest.TimeToEndQuest")) {
            int durationMinutes = this.plugin.getQuestsConfig().getInt("MrCommunityQuest.Quests." + questId + ".Quest.TimeToEndQuest", 600);
            durationSeconds = (long)durationMinutes * 60L;
        }
        this.plugin.getQuestGUI().startQuest(questId, durationSeconds);
        String questName = this.plugin.getQuestsConfig().getString("MrCommunityQuest.Quests." + questId + ".Quest.QuestName", "Quest " + questId);
        sender.sendMessage(this.plugin.getMessageManager().getMessage("quests.quest-started-success").replace("[quest-name]", questName).replace("[quest-id]", questId).replace("[duration]", String.valueOf(durationSeconds / 60L)));
        this.plugin.getServer().broadcastMessage(ColorSystem.colorize(this.plugin.getMessageManager().getMessage("quests.quest-started-broadcast").replace("[quest]", questName).replace("[duration]", String.valueOf(durationSeconds / 60L))));
    }

    private void endQuest(CommandSender sender, String questId) {
        if (!this.plugin.getQuestsConfig().contains("MrCommunityQuest.Quests." + questId)) {
            sender.sendMessage(this.plugin.getMessageManager().getMessage("quests.quest-not-found").replace("[quest-id]", questId));
            return;
        }
        if (!this.plugin.getQuestGUI().isQuestActive(questId)) {
            sender.sendMessage(this.plugin.getMessageManager().getMessage("quests.quest-not-active").replace("[quest-id]", questId));
            return;
        }
        String questName = this.plugin.getQuestsConfig().getString("MrCommunityQuest.Quests." + questId + ".Quest.QuestName", "Quest " + questId);
        this.plugin.getRewardsManager().distributeRewards(questId);
        this.plugin.getQuestManager().getQuestTracker().saveQuestProgress();
        this.plugin.getQuestGUI().endQuest(questId);
        if (this.plugin.getQuestProgressManager() != null) {
            this.plugin.getQuestProgressManager().saveProgress();
        }
        sender.sendMessage(this.plugin.getMessageManager().getMessage("quests.quest-ended-success").replace("[quest-name]", questName).replace("[quest-id]", questId));
        this.plugin.getServer().broadcastMessage(ColorSystem.colorize(this.plugin.getMessageManager().getMessage("quests.quest-ended-broadcast").replace("[quest]", questName)));
    }

    private void sendHelp(CommandSender sender) {
        sender.sendMessage(ColorSystem.colorize(this.plugin.getMessageManager().getMessage("help.admin-header")));
        sender.sendMessage(ColorSystem.colorize(this.plugin.getMessageManager().getMessage("help.admin-help")));
        sender.sendMessage(ColorSystem.colorize(this.plugin.getMessageManager().getMessage("help.admin-reload")));
        sender.sendMessage(ColorSystem.colorize(this.plugin.getMessageManager().getMessage("help.admin-start")));
        sender.sendMessage(ColorSystem.colorize(this.plugin.getMessageManager().getMessage("help.admin-end")));
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            return this.filterCompletions(Arrays.asList("help", "reload", "start", "end"), args[0]);
        }
        if (args.length == 2 && (args[0].equalsIgnoreCase("start") || args[0].equalsIgnoreCase("end")) && this.plugin.getQuestsConfig() != null && this.plugin.getQuestsConfig().contains("MrCommunityQuest.Quests")) {
            return new ArrayList<String>(this.plugin.getQuestsConfig().getConfigurationSection("MrCommunityQuest.Quests").getKeys(false));
        }
        return Collections.emptyList();
    }

    private List<String> filterCompletions(List<String> completions, String arg) {
        ArrayList<String> result = new ArrayList<String>();
        for (String completion : completions) {
            if (!completion.toLowerCase().startsWith(arg.toLowerCase())) continue;
            result.add(completion);
        }
        return result;
    }
}

