/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrcommunityquest.data;

import eu.mrneznamy.mrcommunityquest.MrCommunityQuest;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.configuration.file.YamlConfiguration;

public class QuestProgressManager {
    private final MrCommunityQuest plugin;
    private final File progressFile;
    private YamlConfiguration progressConfig;

    public QuestProgressManager(MrCommunityQuest plugin) {
        this.plugin = plugin;
        this.progressFile = new File(plugin.getDataFolder(), "quest_progress.yml");
        this.loadProgress();
    }

    private void loadProgress() {
        if (!this.progressFile.exists()) {
            this.progressConfig = new YamlConfiguration();
            return;
        }
        try {
            this.progressConfig = YamlConfiguration.loadConfiguration((File)this.progressFile);
        }
        catch (Exception e) {
            this.progressConfig = new YamlConfiguration();
        }
    }

    public void saveProgress() {
        try {
            this.progressConfig.save(this.progressFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Map<UUID, Integer> getQuestProgress(String questId) {
        HashMap<UUID, Integer> progress = new HashMap<UUID, Integer>();
        if (!this.progressConfig.contains("quests." + questId + ".players")) {
            return progress;
        }
        for (String playerIdStr : this.progressConfig.getConfigurationSection("quests." + questId + ".players").getKeys(false)) {
            try {
                UUID playerId = UUID.fromString(playerIdStr);
                int amount = this.progressConfig.getInt("quests." + questId + ".players." + playerIdStr);
                progress.put(playerId, amount);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return progress;
    }

    public int getPlayerProgress(String questId, UUID playerId) {
        return this.progressConfig.getInt("quests." + questId + ".players." + playerId.toString(), 0);
    }

    public void setPlayerProgress(String questId, UUID playerId, int amount) {
        this.progressConfig.set("quests." + questId + ".players." + playerId.toString(), (Object)amount);
    }

    public void addPlayerProgress(String questId, UUID playerId, int amount) {
        int current = this.getPlayerProgress(questId, playerId);
        this.setPlayerProgress(questId, playerId, current + amount);
    }

    public long getQuestEndTime(String questId) {
        return this.progressConfig.getLong("quests." + questId + ".end-time", 0L);
    }

    public void setQuestEndTime(String questId, long endTime) {
        this.progressConfig.set("quests." + questId + ".end-time", (Object)endTime);
    }

    public void removeQuestProgress(String questId) {
        this.progressConfig.set("quests." + questId, null);
    }

    public boolean isQuestActive(String questId) {
        long endTime = this.getQuestEndTime(questId);
        return endTime > 0L && endTime > System.currentTimeMillis();
    }
}

