/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrcommunityquest.economy;

import net.milkbowl.vault.economy.Economy;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public class EconomyManager {
    private Economy economy;

    public EconomyManager(JavaPlugin plugin) {
        this.setupEconomy(plugin);
    }

    private boolean setupEconomy(JavaPlugin plugin) {
        if (plugin.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider rsp = plugin.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return false;
        }
        this.economy = (Economy)rsp.getProvider();
        return this.economy != null;
    }

    public boolean hasEconomy() {
        return this.economy != null;
    }

    public boolean hasMoney(String playerName, double amount) {
        if (this.economy == null) {
            return false;
        }
        return this.economy.has(playerName, amount);
    }

    public boolean withdrawMoney(String playerName, double amount) {
        if (this.economy == null) {
            return false;
        }
        return this.economy.withdrawPlayer(playerName, amount).transactionSuccess();
    }

    public String format(double amount) {
        if (this.economy == null) {
            return String.valueOf(amount);
        }
        return this.economy.format(amount);
    }

    public String currencyNameSingular() {
        if (this.economy == null) {
            return "";
        }
        return this.economy.currencyNameSingular();
    }

    public String currencyNamePlural() {
        if (this.economy == null) {
            return "";
        }
        return this.economy.currencyNamePlural();
    }
}

