/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrcommunityquest.listener;

import com.vexsoftware.votifier.model.VotifierEvent;
import eu.mrneznamy.mrcommunityquest.MrCommunityQuest;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class NuVotifierListener
implements Listener {
    private final MrCommunityQuest plugin;

    public NuVotifierListener(MrCommunityQuest plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onVote(VotifierEvent event) {
        String username = event.getVote().getUsername();
        Player player = Bukkit.getPlayerExact((String)username);
        if (player == null) {
            return;
        }
        UUID playerId = player.getUniqueId();
        this.updateNuVotifierQuestProgress(playerId);
    }

    private void updateNuVotifierQuestProgress(UUID playerId) {
        if (this.plugin.getQuestGUI() == null || this.plugin.getQuestManager() == null) {
            return;
        }
        Map<String, Long> activeQuests = this.plugin.getQuestGUI().getActiveQuests();
        FileConfiguration questsConfig = this.plugin.getQuestsConfig();
        if (questsConfig == null || activeQuests.isEmpty()) {
            return;
        }
        ConfigurationSection questsSection = questsConfig.getConfigurationSection("MrCommunityQuest.Quests");
        if (questsSection == null) {
            return;
        }
        for (String questId : activeQuests.keySet()) {
            String provider;
            ConfigurationSection questSection = questsSection.getConfigurationSection(questId + ".Quest");
            if (questSection == null || !"NUVOTIFIER".equalsIgnoreCase(provider = questSection.getString("Provider", "VANILLA"))) continue;
            this.plugin.getQuestManager().getQuestTracker().updateProgress(questId, playerId, 1);
            this.checkAndCompleteQuest(questId);
        }
    }

    private void checkAndCompleteQuest(String questId) {
        if (this.plugin.getQuestManager() == null || this.plugin.getQuestGUI() == null || this.plugin.getRewardsManager() == null) {
            return;
        }
        FileConfiguration questsConfig = this.plugin.getQuestsConfig();
        if (questsConfig == null) {
            return;
        }
        ConfigurationSection questSection = questsConfig.getConfigurationSection("MrCommunityQuest.Quests." + questId + ".Quest");
        if (questSection == null) {
            return;
        }
        int requiredAmount = questSection.getInt("Amount", 0);
        int totalProgress = this.plugin.getQuestManager().getQuestTracker().getQuestProgress(questId).values().stream().mapToInt(Integer::intValue).sum();
        if (totalProgress >= requiredAmount) {
            this.plugin.getRewardsManager().distributeRewards(questId);
            if (this.plugin.getQuestManager().getQuestTracker() != null) {
                this.plugin.getQuestManager().getQuestTracker().saveQuestProgress();
                this.plugin.getQuestManager().getQuestTracker().resetQuestProgress(questId);
            }
            if (this.plugin.getProgressMessageManager() != null) {
                this.plugin.getProgressMessageManager().resetQuestThresholds(questId);
            }
            this.plugin.getQuestGUI().endQuest(questId);
            String questName = questSection.getString("QuestName", "Quest " + questId);
            if (this.plugin.getServer() != null && this.plugin.getMessageManager() != null) {
                this.plugin.getServer().broadcastMessage(this.plugin.getMessageManager().getMessage("quests.quest-completed-broadcast").replace("[quest]", questName));
            }
        }
    }
}

