/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrcommunityquest.quests;

import eu.mrneznamy.mrcommunityquest.MrCommunityQuest;
import eu.mrneznamy.mrcommunityquest.data.QuestProgressManager;
import eu.mrneznamy.mrcommunityquest.display.ProgressMessageManager;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;

public class QuestTracker {
    private final MrCommunityQuest plugin;
    private final QuestProgressManager questProgressManager;

    public QuestTracker(MrCommunityQuest plugin) {
        this.plugin = plugin;
        this.questProgressManager = plugin.getQuestProgressManager();
    }

    public void updateProgress(String questId, UUID playerId, int amount) {
        if (this.questProgressManager == null) {
            return;
        }
        int previousTotalProgress = this.getQuestProgress(questId).values().stream().mapToInt(Integer::intValue).sum();
        this.questProgressManager.addPlayerProgress(questId, playerId, amount);
        FileConfiguration questsConfig = this.plugin.getQuestsConfig();
        if (questsConfig == null) {
            return;
        }
        ConfigurationSection questSection = questsConfig.getConfigurationSection("MrCommunityQuest.Quests." + questId + ".Quest");
        if (questSection == null) {
            return;
        }
        int requiredAmount = questSection.getInt("Amount", 0);
        if (requiredAmount <= 0) {
            return;
        }
        int newTotalProgress = this.getQuestProgress(questId).values().stream().mapToInt(Integer::intValue).sum();
        int previousPercentage = (int)Math.floor((double)previousTotalProgress * 100.0 / (double)requiredAmount);
        int newPercentage = (int)Math.floor((double)newTotalProgress * 100.0 / (double)requiredAmount);
        if (newPercentage > previousPercentage) {
            String[] progressStrings;
            for (String progressStr : progressStrings = this.plugin.getConfig().getString("MrCommunityQuest.ProgressMessages.Progress", "10,20,30,40,50,60,70,80,90").split(",")) {
                try {
                    ProgressMessageManager progressMessageManager;
                    int threshold = Integer.parseInt(progressStr.trim());
                    if (previousPercentage >= threshold || newPercentage < threshold || (progressMessageManager = this.plugin.getProgressMessageManager()) == null) continue;
                    progressMessageManager.sendImmediateProgressMessage(questId, threshold);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    public int getPlayerProgress(String questId, UUID playerId) {
        if (this.questProgressManager == null) {
            return 0;
        }
        return this.questProgressManager.getPlayerProgress(questId, playerId);
    }

    public Map<UUID, Integer> getQuestProgress(String questId) {
        if (this.questProgressManager == null) {
            return new HashMap<UUID, Integer>();
        }
        return this.questProgressManager.getQuestProgress(questId);
    }

    public boolean isQuestCompleted(String questId) {
        if (this.questProgressManager == null || this.plugin.getQuestsConfig() == null) {
            return false;
        }
        ConfigurationSection questSection = this.plugin.getQuestsConfig().getConfigurationSection("MrCommunityQuest.Quests." + questId + ".Quest");
        if (questSection == null) {
            return false;
        }
        int requiredAmount = questSection.getInt("Amount", 0);
        Map<UUID, Integer> progress = this.getQuestProgress(questId);
        if (progress == null) {
            return false;
        }
        int totalProgress = progress.values().stream().mapToInt(Integer::intValue).sum();
        return totalProgress >= requiredAmount;
    }

    public void resetQuestProgress(String questId) {
        if (this.questProgressManager == null) {
            return;
        }
        this.questProgressManager.removeQuestProgress(questId);
        this.questProgressManager.saveProgress();
    }

    public void saveQuestProgress() {
        if (this.questProgressManager == null) {
            return;
        }
        this.questProgressManager.saveProgress();
    }
}

