/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrcommunityquest.data;

import eu.mrneznamy.mrcommunityquest.MrCommunityQuest;
import eu.mrneznamy.mrcommunityquest.data.PlayerData;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.configuration.file.YamlConfiguration;

public class DataManager {
    private final MrCommunityQuest plugin;
    private final File dataFolder;
    private final Map<UUID, PlayerData> playerDataCache;

    public DataManager(MrCommunityQuest plugin) {
        this.plugin = plugin;
        this.dataFolder = new File(plugin.getDataFolder(), "data");
        this.playerDataCache = new HashMap<UUID, PlayerData>();
        if (!this.dataFolder.exists()) {
            this.dataFolder.mkdirs();
        }
    }

    public PlayerData getPlayerData(UUID playerId) {
        if (this.playerDataCache.containsKey(playerId)) {
            return this.playerDataCache.get(playerId);
        }
        PlayerData data = this.loadPlayerData(playerId);
        this.playerDataCache.put(playerId, data);
        return data;
    }

    private PlayerData loadPlayerData(UUID playerId) {
        File dataFile = new File(this.dataFolder, playerId.toString() + ".yml");
        if (!dataFile.exists()) {
            return new PlayerData(playerId);
        }
        try {
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)dataFile);
            PlayerData data = new PlayerData(playerId);
            data.setBlocksBroken(config.getInt("stats.blocks-broken", 0));
            data.setEntitiesKilled(config.getInt("stats.entities-killed", 0));
            data.setDonateAmount(config.getDouble("stats.donate-amount", 0.0));
            data.setExpDonateAmount(config.getInt("stats.exp-donate-amount", 0));
            data.setLevelDonateAmount(config.getInt("stats.level-donate-amount", 0));
            data.setParticipated(config.getBoolean("participated", false));
            return data;
        }
        catch (Exception e) {
            return new PlayerData(playerId);
        }
    }

    public void savePlayerData(UUID playerId) {
        PlayerData data = this.playerDataCache.get(playerId);
        if (data == null) {
            return;
        }
        File dataFile = new File(this.dataFolder, playerId.toString() + ".yml");
        try {
            YamlConfiguration config = new YamlConfiguration();
            config.set("stats.blocks-broken", (Object)data.getBlocksBroken());
            config.set("stats.entities-killed", (Object)data.getEntitiesKilled());
            config.set("stats.donate-amount", (Object)data.getDonateAmount());
            config.set("stats.exp-donate-amount", (Object)data.getExpDonateAmount());
            config.set("stats.level-donate-amount", (Object)data.getLevelDonateAmount());
            config.set("participated", (Object)data.hasParticipated());
            config.save(dataFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void saveAllPlayerData() {
        for (UUID playerId : this.playerDataCache.keySet()) {
            this.savePlayerData(playerId);
        }
    }

    public void removePlayerDataFromCache(UUID playerId) {
        this.playerDataCache.remove(playerId);
    }
}

