/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrcommunityquest.data;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;

public class PlayerSettings {
    private final UUID playerId;
    private boolean actionBarEnabled;
    private final Set<String> completedQuests;

    public PlayerSettings(UUID playerId) {
        this.playerId = playerId;
        this.actionBarEnabled = true;
        this.completedQuests = new HashSet<String>();
    }

    public UUID getPlayerId() {
        return this.playerId;
    }

    public boolean isActionBarEnabled() {
        return this.actionBarEnabled;
    }

    public Set<String> getCompletedQuests() {
        return new HashSet<String>(this.completedQuests);
    }

    public boolean hasCompletedQuest(String questId) {
        return this.completedQuests.contains(questId);
    }

    public void setActionBarEnabled(boolean actionBarEnabled) {
        this.actionBarEnabled = actionBarEnabled;
    }

    public void addCompletedQuest(String questId) {
        this.completedQuests.add(questId);
    }

    public void removeCompletedQuest(String questId) {
        this.completedQuests.remove(questId);
    }
}

