/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrcommunityquest.data;

import eu.mrneznamy.mrcommunityquest.MrCommunityQuest;
import eu.mrneznamy.mrcommunityquest.data.PlayerSettings;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.configuration.file.YamlConfiguration;

public class PlayerSettingsManager {
    private final MrCommunityQuest plugin;
    private final File settingsFolder;
    private final Map<UUID, PlayerSettings> playerSettingsCache;

    public PlayerSettingsManager(MrCommunityQuest plugin) {
        this.plugin = plugin;
        this.settingsFolder = new File(plugin.getDataFolder(), "settings");
        this.playerSettingsCache = new HashMap<UUID, PlayerSettings>();
        if (!this.settingsFolder.exists()) {
            this.settingsFolder.mkdirs();
        }
    }

    public PlayerSettings getPlayerSettings(UUID playerId) {
        if (this.playerSettingsCache.containsKey(playerId)) {
            return this.playerSettingsCache.get(playerId);
        }
        PlayerSettings settings = this.loadPlayerSettings(playerId);
        this.playerSettingsCache.put(playerId, settings);
        return settings;
    }

    private PlayerSettings loadPlayerSettings(UUID playerId) {
        File settingsFile = new File(this.settingsFolder, playerId.toString() + ".yml");
        if (!settingsFile.exists()) {
            return new PlayerSettings(playerId);
        }
        try {
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)settingsFile);
            PlayerSettings settings = new PlayerSettings(playerId);
            settings.setActionBarEnabled(config.getBoolean("action-bar-enabled", true));
            config.getStringList("completed-quests").forEach(settings::addCompletedQuest);
            return settings;
        }
        catch (Exception e) {
            return new PlayerSettings(playerId);
        }
    }

    public void savePlayerSettings(UUID playerId) {
        PlayerSettings settings = this.playerSettingsCache.get(playerId);
        if (settings == null) {
            return;
        }
        File settingsFile = new File(this.settingsFolder, playerId.toString() + ".yml");
        try {
            YamlConfiguration config = new YamlConfiguration();
            config.set("action-bar-enabled", (Object)settings.isActionBarEnabled());
            config.set("completed-quests", settings.getCompletedQuests());
            config.save(settingsFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void saveAllPlayerSettings() {
        for (UUID playerId : this.playerSettingsCache.keySet()) {
            this.savePlayerSettings(playerId);
        }
    }

    public void removePlayerSettingsFromCache(UUID playerId) {
        this.playerSettingsCache.remove(playerId);
    }

    public void toggleActionBar(UUID playerId) {
        PlayerSettings settings;
        settings.setActionBarEnabled(!(settings = this.getPlayerSettings(playerId)).isActionBarEnabled());
        this.savePlayerSettings(playerId);
    }
}

